/*								// ****************************** product.js ***
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
var session_lang = "<?= $_SESSION['lang'] ?>";
var imgPath 	 = "Upload/";            	// ---------- path to product images ---
var actProd 	 = 0;						// ------------- selected product no ---

function add_edit_product(id) {	        // ****** get modal data, ajax req.2 ***
		
	$.ajax({		
		url: 'product_ajax.php',
		type: 'post',				//	$('#id').val(response.data.id);
		data: {request: 2, id: id},	//	$('#a1_img').val(response.data.a1_img);
		dataType: 'json',			//	$('#a2_cat').val(response.data.a2_cat);
		success: function(response){
			if (response.status == 1) {
							// ------------------------------ Display Modal ---
				$('#edit_modal').modal('show');
							// ------------------------------- Update Modal ---
				$.each(response.data, function(key, attr) {
					if (key != 0 ) {
						label = attr[0];
						value = attr[1];	
//						if (0 && id == 0 && protoArray.indexOf(optText) < 0 ) 
//							document.getElementById(key).placeholder = value; else
						el = document.getElementById(key);
						if (key == 'a1_img') {
							if (value > '') {
                                el.src = "upload/"+response.data['a6_supp'][1]+"/"+value; 
                            } else { 
                                el.src = "upload/Common/SPE_logo_blue.png";
                            }
//							el.src = "data:image/png;base64,"+value;
						} else {
							$('label[for='+key+']').text(label);
							el.value = value;
						}
//						$('#'+key).val(value);
//console.log(key+"= "+el.value+" or "+el.src);
					}
				});
				$('#productTable').DataTable().ajax.reload();
			} else {
				msg = ( session_lang == '_de' ) ? "WRN:Bitte ein Produkt auswählen." 
                                                : "WRN:Please select a product.";
				messageDialog(msg);
			}
		}
	});
}
function save_product(id) {		        // ** ins/update product, ajax req.3 ***
/*    var editForm = $("#edit_form").serializeArray();

	var a8_prot = '';
	var newForm = {};

/*    $.each(editForm, function(i, field) {
        console.log(i + ". " + field.name + ":" + field.value);
    });
*
	editForm.forEach( function (item, value) {
//console.log(item.name+": "+item.value);
		if (item.name == 'a8_prot') {
			a8_prot = a8_prot + item.value+",";
		} else newForm[item.name] = item.value;
	});
	newForm.a8_prot = a8_prot;
//console.log( newForm );
	var project = {};
	editForm.map(function(x) {
//	$("#edit_form").serializeArray().map(function(x) {
		project[x.name] = x.value;
	});
*/
    var editForm = $("#edit_form").serializeArray();
	var rowdata = editForm;
	$.ajax({		
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 3, id: id, rowdata:rowdata},	
		dataType: 'json',
		success: function(response){
			msg=response.message;
			if (response.status == 1) {	// -------- Display and Update Modal ---
				$('#edit_modal').modal('hide');
				messageDialog(msg, function (close) {
					if (close) {
						location.reload(true);
					}
				});
			} else {
//console.log("success, status != 1");
			}
        },
        error: function(data){
//console.log(data);
        }
	});
}
function delete_product(id) { 	        // ****** delete product, ajax-req 4 ***
//alert('request ajax 4: '+id);
	$.ajax({		
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 4, id: id},
		dataType: 'json',
		success: function(response) {
//alert(response.status);
			if (response.status == 1) {
				$('#edit_modal').modal('hide');
				messageDialog(response.message, function (yes) { 
					if (yes) {	location.reload(true);	}
				});
			} else {
				messageDialog(response.message, function (yes) { });
			}
		},
		error: function (jqXhr, textStatus, errorMessage) {
//alert('Error' + errorMessage);
        }
	});
}
function vote_product(vote,cand,pid) {	// **************** vote for product ***
//alert("vote: "+vote+" cand: "+cand+" pid: "+pid);
	$.ajax({		
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 9, vote:vote,cand:cand,pid:pid},
		dataType: 'json',
		success: function(response){
			msg = response.message;
			messageDialog(msg);
		}
	});
}
function select_single(fld,row_text) {	// ******* single select, ajax-req 5 ***
	$.ajax({
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 5, field: fld},
		dataType: 'json',
		success: function(response) {
			if (response.status == 1) {
				var data = response.data;
				var no = 0;
				var selno = -1;
//console.log(data);
				$.each(data, function(id, row){
					optValue = row.id;
					if (fld == 'a2_cat' && optValue == 'c0_all') return;
					optText = row.text;
					if (row_text == optText) { selno = no; }
					$('#'+fld).append(`<option value="${optValue}">${optText}</option>`);
					no++;
				});
				if (selno >= 0) $('#'+fld).prop('selectedIndex', selno);
			}
		}
	});
}
function upload_product(id) {	        // ****** upload picture, ajax-req 6 ***
	$.ajax({		
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 6, id: id},
		dataType: 'json',
		success: function(response) {
			response = JSON.parse(response);
//console.log(response);
			if(response.status == 1) {
				messageDialog(response.message, function (yes) { 
					location.reload(true);
				});
			} else {
				messageDialog(response.message, function (yes) { });
			}
		}
	});
}
function select_multiple(fld,protoList){// ***** multiple select, ajax-req 7 ***
	var protoArray = (protoList) ? protoList.split(',') : '';
	$.ajax({
		url: 'product_ajax.php',
		type: 'post',
		data: {request: 7},
		dataType: 'json',
		success: function(response) {
			if (response.status == 1) {
				var no = 0;
				var data = response.data;
				$.each(data, function(id, row){
					optValue = row.id;
					optText = row.text;
//console.log(optText);
					if (protoArray.indexOf(optText) < 0) { 
						$('#'+fld).append(`<option value="${optText}" >${optText}</option>`);
					} else {
						$('#'+fld).append(`<option value="${optText}" selected >${optText}</option>`);
					}
					no++;
				});
			}
		}
	});
}
function printObj(obj) {
    var string = '';

    for(var prop in obj) {
        if(typeof obj[prop] == 'string') {
            string+= prop + ': ' + obj[prop]+'; </br>';
        }
        else {
            string+= prop + ': { </br>' + print(obj[prop]) + '}';
        }
    }

    return string;
}
/*							
 * *************************** Product Ajax Functions **************************
 */

$(document).ready(function() { 

	var vis_right = 'invisible';
	if (right == 'super' || right == 'admin') { vis_right = 'visible'; }
	
	if ('select_value' in window) {
        data = { request: 1, view: { value: view }, select: {value: select_value} };
    } else { 
        data = { request: 1, view: { value: view } }; 
    }
    if ( session_lang == "_de" ) act_lang = "assets/DataTables/i18n/German.json";
    else act_lang = "assets/DataTables/i18n/English.json";
                                // ******************************* DataTable ***
	var productTable = $('#productTable').DataTable({
		'sPaginationType': 'full_numbers',
		'processing': true,
		"oSearch": {"sSearch": select_value},
		'serverSide': true,
		'serverMethod': 'post',
		ajax: {					// ****************** ajax req.1: init table *** 
			url: "product_ajax.php",
			type: 'POST',
			rowid:'id',
            data: data
		},
		createdRow: function (row, data, index) {
			var state = data["state"];
			$(row).addClass(state);
        },
		columns: [				// ********************************* Columns ***
			{ data: 'id', type: "readonly" },		
			{ data: 'a4_pn', render: function ( data, type, row ) {
                    var href = row['a7_ref'];
                    if (href) return "<a href='" + href + "' target='_blank' >" + data + '</a>'; 
                    else return data;
            } },
			{ data: 'a1_img', "render": function (data, type, row, meta) {
					if (!data) data = "backup/Common/SPE_logo_blue.png"; 
                    else data = "backup/"+row.a6_supp+"/"+data;
                    return `<img style='max-height:40px;max-width:80px;' id='a1_img' name='a1_img' src='${data}' />`;
			} },
			{ data: 'a5_pr', render: $.fn.dataTable.render.ellipsis( 30, false ) },
			{ data: 'a6_supp'},	
			{ data: 'a8_prot', render: $.fn.dataTable.render.ellipsis( 20, false )	},
			{ data: 'state', render: function (data, type, row, meta) {
					var ret = data;
					if (data == 'preSeries')
{
                         ret = '<svg width="40" height="40"><circle cx="12" cy="12" r="10" stroke="yellow" stroke-width="1" fill="blue" /></svg>';
//alert("preSeries: "+ret);
}
					if (data == 'ComingSoon')
{
                        ret = '<svg width="40" height="40"><circle cx="12" cy="12" r="10" stroke="yellow" stroke-width="1" fill="orange" /></svg>';
//alert("ComingSoon: "+ret);
}

					if (data == 'Active')
{
                        ret = '<svg width="40" height="40"><circle cx="12" cy="12" r="10" stroke="yellow" stroke-width="1" fill="green" /></svg>';
//alert("Active: "+ret);
}
					if (data == 'PhaseOutSelected')
                        ret = '<svg width="40" height="40"><circle cx="12" cy="12" r="10" stroke="yellow" stroke-width="1" fill="silver" /></svg>';
					if (data == 'PhaseOut')
{
                        ret = '<svg width="40" height="40"><circle cx="12" cy="12" r="10" stroke="yellow" stroke-width="1" fill="black" /></svg>';
//alert("PhaseOut: "+ret);
}
					return ret; 
			} },
			{ data: 'a3_typ' },
			{ data: 'a2_cat', type : "select",
				render: function (data, type, row, meta) {
					return row.a2_cat;
			} },
			{ data: 'b1' },
			{ data: 'b2' },
			{ data: 'b3' },	
			{ data: 'b4' },
			{ data: 'b5' },
			{ data: 'b6' },	
			{ data: 'b7' },
			{ data: 'b8' },
			{ data: 'b9' },	
			{ data: 'ba' }
/*	
			{ data: 'state' }
			{ data: 'upd_id' },
			{ data: 'updated'},	
			{ data: 'crd_id' },
			{ data: 'created' }
*/
		],

/*		columnDefs: [ 
			{ targets: 5, render: $.fn.dataTable.render.ellipsis( 20, false ) },
			{ targets: 7, render: $.fn.dataTable.render.ellipsis( 20, false ) },
			{ targets: 8, rendernn5: $.fn.dataTable.render.ellipsis( 20, false ) }
		],
*/
		dom: 		'Bfrtlp',	// B-utton,f-ind,p-r-ocess,t-able,l-ength,i-nfo,p-agination
		select: 	'single',
		altEditor:	true,		// Enable altEditor
		responsive: {			// ********************** display responsive ***
            details: {
                display: $.fn.dataTable.Responsive.display.modal( {
                    header: function ( row ) {
                        var data = row.data();
                        return 'Details for '+data['a3_typ']+':<br> '+data['a5_pr'];
                    }
                }),
                renderer: $.fn.dataTable.Responsive.renderer.tableAll()
            }
        },
		buttons: [				// *********************** dataTable buttons *** 
			{ text: 'Add',		// ****************************** Add Button ***
//				name: 'add',
				className: vis_right,
				action: function ( e, dt, node, config ) {
					var dta = productTable.rows(0).data();
                    add_edit_product(0);
					if (dta.length > 0) { 
                        var cat = dta[0].a2_cat;
                        var typ = dta[0].a3_typ;
                        var sup = dta[0].a6_supp;
                        var prt = dta[0].a8_prot
                    } else {
                        if (session_lang == "_de") { var cat = "Kabel"; var typ = "Buchse"; } 
                        else { var cat = "Cable"; var typ = "jack"; }
                        var sup = "HARTING";
                        var prt = "10BASE-T1S,10BASE-T1L,100BASE-T1,1000BASE-T1,PoDL";
                    }
                    select_single('a2_cat',cat);
//					select_single('a3_typ',typ);
//					select_single('a6_supp',sup);
					select_multiple('a8_prot',prt);
				}
			},
			{ text: 'Edit',		// ***************************** Edit Button ***
//				name: 'edit',
				extend: 'selected',
				className: vis_right,
				action: function ( e, dt, node, config ) {
					var dta = productTable.rows({selected:  true}).data();
					if (dta.length > 0) { 
						add_edit_product(actProd);
						select_single('a2_cat',dta[0].a2_cat);
//						select_single('a3_typ',dta[0].a3_typ);
//						select_single('a6_supp',dta[0].a6_supp);
						select_multiple('a8_prot',dta[0].a8_prot);
					} else {
						msg=(session_lang == '_de') ? "WRN:Bitte ein Produkt auswählen." 
                                                    : "WRN:Please select a product.";
						messageDialog(msg);
					}
				}
			},
			{ text: 'Delete',	// *************************** Delete Button ***
//				name: 'delete',
				extend: 'selected',
				className: vis_right,
				action: function ( e, dt, node, config ) { 
					confText = (session_lang == '_de') ? "Produkt Nr. "+actProd+" wirklich löschen?" : "Really delete product no "+actProd+"?";
					confirmDialog(confText, function (yes) {
						if (yes) {
							delete_product(actProd);
//							document.location.reload();
						}
					});
				}
			},
			{ text: act_vote,	// ***************************** Vote Button ***
				id: 'vote',
				className: vis_right,
				action: function ( evt, dt, node, config ) {
					var text=$('#vote').text();
					$(this).text(act_vote);
				}
			},
			{ text: 'Cand_1',	// ********************** 1. Candidat Button ***
				extend: 'selected',
				className: vis_right,
				action: function ( evt, dt, node, config ) {
/*					var dta = productTable.rows(0).data();
					id   = dta[0].id
					cat  = dta[0].a2_cat;
					prod = dta[0].a4_pn;
					supp = dta[0].a6_supp;
*/					vote_product(act_vote, 1, actProd);
				}
			},
			{ text: 'Cand_2',	// ********************** 2. Candidat Button ***
				extend: 'selected',
				className: vis_right,
				action: function ( evt, dt, node, config ) {
//					var dta = productTable.rows(0).data();
					vote_product(act_vote, 2, actProd);		
				}
			},
			{ text: '3. Cand',	// ********************** 3. Candidat Button ***
				extend: 'selected',
				className: vis_right,
				action: function ( evt, dt, node, config ) {
//					var dta = productTable.rows(0).data();
					vote_product(act_vote, 3, actProd);		
				}
			}
		],
		info:		true,
		paging:		true,
		ordering:	true,
		searching:	true,
		pageLength:	10,
		order: 		[ 0, 'asc' ],
		select: 	true,
							// ****************** ajax req.3: on Add Product ***
        onAddRow: function (datatable, rowdata, success, error) {
			$.ajax({
				url: 'product_ajax.php',
				type: 'post',
				data: {request: 3, id: 0, rowdata},
				dataType: 'json',
				success: function(response){
					if(response.status == 1){
					}
				}
            });
        },
							// *************** ajax req.4: on Delete Product ***
		onDeleteRow: function(datatable, rowdata, success, error) {
            $.ajax({
				url: 'product_ajax.php',
				type: 'post',
				data: {request: 4, id: 0, rowdata},
				dataType: 'json',
				success: function(response){
					if(response.status =nn5= 1){
					}
				}
            });
        },
        onEditRow: function(datatable, rowdata, success, error) {
           $.ajax({
 				url: 'product_ajax.php',
				type: 'post',
				data: { request: 3, rowdata },
				dataType: 'json',
				success: function(response){
					if(response.status == 1){
					}
				}
            });
		},
		language: {			// ***************** ajax load translation table ***
			url: act_lang
		}
	});
/*							// ***************** POST edit_form, ajax req. 3 ***
    $("form").on("submit", function(event){
        event.preventDefault();	// ---- prevent default right click handling ---
 
		var formValues= $(this).serialize();
								// ------------------- multi select handling ---
		var regno = formValues.match(/a8_prot\=/g);
		if (regno && regno.length > 1) {	
// console.log(regno.length);
			var regex = new RegExp(/a8_prot\=([\w-]+)\&/);
			var extnd = new RegExp(/a8_prot\=([\w-]+)\&/);
			var repl  = 'a8_prot=$1,';
			for (i = 1; i < regno.length; i++) {
				regex = new RegExp(regex.source + extnd.source);
				repl  += '$'+(i+1)+',';
			}
			repl = repl.replace(/.$/,"&");
// console.log(regex.source+', '+repl);
			var formValues = formValues.replace(regex,repl);
		} 						// --------- ajax req 3, hidden in edit_form ---
        $.post("product_ajax.php", formValues, function(response){
			response = JSON.parse(response);
			if (response["status"] == 1) {
				$('#edit_modal').modal('hide');
				messageDialog(response.message, function (yes) { 
					if (yes) {	location.reload(true);	}
				});
			} else {
				messageDialog(response.message, function (yes) { });
			}
        });
	});
*/
	productTable			// *************** set actual product to actProd ***
		.on( 'select', function ( e, dt, type, indexes ) {
			var rowData = productTable.rows( indexes ).data().toArray();
			actProd = rowData[0].id;
//-alert("select: " + actProd);
//			events.prepend( '<div><b>'+type+' selection</b> - '+JSON.stringify( rowData )+'</div>' );
		} )
		.on( 'deselect', function ( e, dt, type, indexes ) {
			var rowData = productTable.rows( indexes ).data().toArray();
			actProd = 0;
//-alert("deselect: "+actProd);
//			events.prepend( '<div><b>'+type+' <i>de</i>selection</b> - '+JSON.stringify( rowData )+'</div>' );
		} );
/*		
	$(function() {			// ******************************** context menu ***
		$.contextMenu({
			selector: '#productTable',
			events: {
				show : function(options){
//alert("contextMenu: " + actProd);
					if (actProd == 0) {
						itemsDisabled["edit"] = true; 			// Disable 'edit' menu item.
						this.addClass('currently-showing-menu'); // Add class to the menu
//alert("contextMenu1: " + this.class);
						if (session_lang == '_de') alert("Bitte Produkt auswählen.");
						else alert("Please select product.");
						return false;
					}

//				return false;
				}
			},

			callback: function(key, options) {
				var clickedKey= key;			//How to get the Value of the clicked cell here ?
				var  m = $(options.$trigger).text();
//				window.console && console.log(m) || alert(m);
			},
			items: {
				"Menu": {name: "Product: "+actProd,
					callback: function(key, options) {
//alert("Menu: "+actProd);
					}
				},
				"add": {name: "Add", icon:  "add",
					callback: function(key, options) {
					var dta = productTable.rows(0).data();
//alert("add: " + dta[0].a2_cat);
					if (dta.length > 0) { 
						add_edit_product(0);
						select_single('a2_cat',dta[0].a2_cat);
						select_multiple('a8_prot',dta[0].a8_prot);
					}
				}
				},
				"edit": {name: "Edit", icon: "edit",
					callback: function(key, options) {
						var dta = productTable.rows({selected:  true}).data();
//console.log(dta);
						if (dta.length > 0) { 
							add_edit_product(actProd);
							select_single('a2_cat',dta[0].a2_cat);
							select_multiple('a8_prot',dta[0].a8_prot);
						}
					},
					disabled: function(key, opt) {
						if (actProd == 0) return true; 
					}
				},
				"delete": {name: "Delete", icon: "delete",
					callback: function(key, options) {
						confText = (session_lang == '_de') 
							? "Produkt Nr. "+actProd+" wirklich löschen?"
							: "Really delete product no "+actProd+"?";
						confirmDialog(confText, function (yes) {
							if (yes) { 
								delete_product(actProd);
//								document.location.reload();
							}
						});
					},
					disabled: function(key, opt) {
						if (actProd == 0) return true; 
					}
				},
				"upload": {name: "Picture", 				// icon: "upload",
					callback: function(key, options) {
						$('#file').click();
					},
					disabled: function(key, opt) {
						if (actProd == 0) return true; 
					}
				},
				"refresh": {name: "Refresh", 				// icon: "refresh"},
					callback: function(key, options) {
						document.location.reload();
					}
				},
				"sep1": "---------",
				"quit": {name: "Quit", icon: 'quit',
					callback: function(key, options) {
						document.location.href = 'home.php';
						return 'context-menu-icon context-menu-icon-quit';
					}
				}
			}
		});

		$('#productTable').on('click', function(e) {
				setTimeout( function() {
				var dta = productTable.rows({selected:  true}).data();
				if (dta.length > 0) id = dta[0].id; else return;
//				var id = $(this).closest('tr').children('td:first').text();
//				var id = $(this).closest('tr').children('td:first');
//console.log('clicked ', id);
			}, 100);
		})

	});
*/
/*							// **************** double click to edit product ***
	$('#productTable').on( 'dblclick', 'tbody td:not(:first-child)', function (e) {
		var id = $(this).closest('tr').children('td:first').text();
		$('#file').click();
				//	FIXME: dblclick edit does not generate select options		
//		add_edit_product(id);
	});
	$("#a1_img").click(function(){
	var tds = tr.find("td[id='a1_img']");
*/
/*							// ****************** double click to edit image ***
	$('#productTable').on( 'dblclick', $("tbody>td>td>#a1_img"), function (e) {
//		alert('image clicked');
    });     
*/
/*							// ****************************** click upd_save ***
	$('#productTable').on( 'click', 'upd_save', function (e) {
//alert("upd_save");
		var dta = productTable.rows({ selected:  true }).data();
		if (dta.length > 0) add_edit_product(dta[0].id);
	});
*/
							// ************* ajax req.6; process_file_button ***
	$('#process-file-button').on('click', function (e) {
		let files = new FormData(); // you can consider this as 'data bag'
		id = actProd;

		files.append('request', 6); 
		files.append('id', id); 
		files.append('fileName', $('#file')[0].files[0]); // append selected file to the bag named 'file'
		
		$.ajax({
			url : "product_ajax.php",
			type: "POST",
			processData: false,
			contentType: false,
			data: files,
			success: function (response) {
				response = JSON.parse(response);
//console.log(response["status"]);
				if (response["status"] == 1) {	// ---- Display and Update Modal ---
					messageDialog(response.message, function (close) { 
						if (close) { location.reload(true); }
					});
				} else {
					id = actProd;  // actual product no
					messageDialog(response.message, function (close) { });
				}
			},
			error: function (err) {
//console.log(err);
			}

		});
	});
							// ************************************** logout ***
	$(document).on('click', "#returnBtn", function() {
		document.location.href = "home.php";
	});
							// ************************* edit_form on submit ***
	$('#edit_form').on("submit", function(event) {
		event.preventDefault();
		save_product(actProd);
	});

});								// document ready function

