<?php
///	ini_set("error_log", "/tmp/php-error.log");
/*
 * *************************** maintenance.php *********************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * *****************************************************************************
 * 
 * *****************************************************************************
 * backup.php
 * this backup is called from admin.
 * it includes assets/php/backup.php, which may be called by crontab.
 * *****************************************************************************
echo("<pre>"); print_r($_GET); echo("</pre>");
echo("<pre>"); print_r($allowed_hosts); echo("</pre>");
 */

if (session_id() == '') { session_start(); };
$_SESSION["lang"] = "_en";

$now = date('Y-m-d H:i');
$usr_id = (isset($_SESSION['usr_id'])) ? $_SESSION['usr_id'] : 'na';
$base_fldr = '/var/www/smartSPE/';
$base_path = '/var/www/';

function write_log($prio, $msg, $msg_ge = NULL) {   //  write message to log ---
	global $log_state, $now, $usr_id, $base_fldr;
	
	$fn = "$base_fldr/data/php-error.log";
	if (!$fp = fopen($fn, 'a')) return "ERR: file $fn open error";
			 
	$msg = (isset($_SESSION["lang"]) and $_SESSION["lang"] == "_de" and (!empty($msg_ge))) ? $msg_ge : $msg;
	$rec = "$now - $usr_id > $prio: $msg<br>";
	$n = fwrite($fp, $rec);
	fclose($fp);
//echo "- $n - $prio: $msg<br>";
	return "$prio: $msg";
}


ob_implicit_flush(true);
ob_end_flush(); 

/* ****************************** backup database *****************************/
									// ------------------ database parameter ---
    $db_host = (isset($_SERVER["HTTP_HOST"])) ? $_SERVER["HTTP_HOST"] : 'product.single-pair-ethernet.com';
	$db_tabs = (isset($_GET["backup_db"])) ? $_GET["backup_db"] : 'all';
	$db_serv = (isset($_GET["server_db"])) ? $_GET["server_db"] : "$db_host";
	$db_pass = ($db_serv == 'spe.nb-hp') ? 'P23RfB5U' : 'MySQL&Warrior';	
	$db_user = 'hans';
	$db_base = 'smartSPE';
	$db_back = "{$base_fldr}backup/Database/smartSPE";
	$db_file = ($db_tabs == 'all') ? "{$db_back}.sql" : "{$db_back}_{$db_tabs}.sql";
	$db_tabl = ($db_tabs == 'all') ? '' : $db_tabs;
	echo("start backup on $db_host<br>");
	$cmd = "mysqldump --host='$db_host' --user='$db_user' --password='$db_pass' $db_base $db_tabl > $db_file";
//echo("$cmd<br>");	
	shell_exec($cmd);
	if (file_exists($db_file) && filesize($db_file) > 100) {
		$msg = write_log('MSG',"admin backup_db - smartSPE DB dumped to $db_file",
							   "admin backup_db - smartSPE DB gesichert nach $db_file" );
		shell_exec("chmod 775 $db_file");
		echo("$msg<br>");
	} else {
		$msg = write_log('ERR','admin backup_db - smartSPE DB dump error',
							   'admin backup_db - smartSPE DB Dump Fehler' );
		echo("$msg<br>");
		exit(0);
	}
/* *************************** end for tables only ****************************/

	if ($db_tabs !== 'all') exit(0);

/* ****************************** zip website *********************************/
									// ----------------------- zip parameter ---
	$zip_name = 'smartSPE.zip';
	
	$zip_file = "{$base_path}{$zip_name}";
	$cmd = "zip -r -q $zip_file $base_fldr";
// echo("$cmd<br>");
	$res = shell_exec($cmd);
	shell_exec("chmod 775 $zip_file");
	if (file_exists($zip_file) && filesize($zip_file) > 1000) {
		$msg = write_log('MSG',"admin backup_db - smartSPE website zipped to $zip_file",
							   "admin backup_db - smartSPE Website zipped nach $zip_file" ); 
		echo("$msg<br>");
	} else {
		$msg = write_log('ERR','admin backup_db - zip smartSPE failed',
							   'admin backup_db - Zip smartSPE Fehler' );
		echo("$msg<br>");
		exit(0);
	}
/* **************************** copy zipped website ***************************/
									// ---------- copy destination parameter ---
	$dst_host = 'qoscom.de';
	$dst_path = '/var/www/Backups/';
	$dst_user = 'hans';
	$dst_pass = 'Y-3l&abX';
	$dst_from = 'SPE';
	$dst_maxB = 5;

	$dat = date('ymd');
	$dst_file = "{$dst_path}{$dat}_{$dst_from}_{$zip_name}";
	if ( !$conn = ssh2_connect($dst_host, 22) or
		!ssh2_auth_password($conn, $dst_user, $dst_pass) ) {
		$msg = write_log("ERR","backup - failed to connect to $dst_host",
							   "backup - Fehler bei der Verbindung zu $dst_host");
		echo("$msg<br>");
		exit(0);
	}
	$sftp = ssh2_sftp($conn);
	$sftp_fd = intval($sftp);

	$dirHdl = opendir("ssh2.sftp://$sftp_fd/$dst_path");
	while (false !== ($file = readdir($dirHdl))) {
		if ($file != '.' && $file != '..') {
			$files[] = $file;
// echo "$file<br>";
		}
	}
	$to_del = count($files) - $dst_maxB;
	foreach ($files as $file) {
		if ($to_del > 0) {
			ssh2_sftp_unlink($sftp, "{$dst_path}{$file}");
			$to_del -= 1;
			$action = 'deleted';
		} else $action = 'saved';
		echo "$file $action<br>";
	}
	if (ssh2_scp_send($conn, $zip_file, $dst_file, 0644) ) {
		$msg = write_log('MSG',"backup - smartSPE database and website saved in $dst_file",
							   "backup - smartSPE Datenbank und Website gesichert in $dst_file" );
		echo("$msg<br>");
	} else {
		$msg = write_log("ERR","backup - failed to copy website to $dst_host, $dst_file",
							   "backup - Fehler beim kopieren der Website nach $dst_host, $dst_file");
		echo("$msg<br>");
	}
	echo("backup finished<br>");
?>
