<?php
ini_set('display_errors',1); 
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//index.php

include('database_connection.php');

$query = "SELECT * FROM task_list WHERE user_id = '".$_SESSION["user_id"]."' ORDER BY task_list_id DESC";

$lang = '_de';
$statement = $connect->prepare($query);
$statement->execute();
$result = $statement->fetchAll();
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Developed To-Do List in PHP using Ajax</title>  
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" />
        <link rel="stylesheet" href="assets/css/smartspe.css">

        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
            <style>
            body { font-family: 'arial'; }
            .list-group-item { font-size: 26px; }
        </style>
    </head>
    <body>
        <nav class="navbar navbar-light navbar-expand-md bg-white pt-1 pb-1">
            <div class="container-fluid"><a class="navbar-brand logo" href="https://www.single-pair-ethernet.com/">
                <img class="img-responsive" src="../images/spe_logo.png" style="width: 220px"></a>
                <nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
                    <div class="container">
                        <button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navcol-1">
                            <span class="navbar-text actions"> 
                                <h1 class="german" align="center">smartSPE Aufgaben Liste</h1> 
                                <h1 class="english" align="center">smartSPE Task List</h1> 
                            </span>
                            <span class="navbar-text actions"> 
                                <button class="btn action-button bg-warning german" onClick="location.href = '../../home.php' ">Zurück</button>
                                <button class="btn action-button bg-warning english" onClick="location.href = '../../home.php' ">Back</button>
                            </span>
                        </div>
                    </div>
                </nav>
            </div>
        </nav>
<!-- ------------------------------------------------------------------------- -->
        <div class="container">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-9">
                            <h3 class="panel-title">My To-Do List</h3>
                        </div>
                        <div class="col-md-3">
                            Rest
                        </div>
                    </div>
                </div>
                <div class="panel-body">
                    <form method="post" id="to_do_form">
                        <span id="message"></span>
                        <div class="input-group">
                            <input type="text" name="task_name" id="task_name" class="form-control input-lg" 
                                autocomplete="off" placeholder="Title..." />
                            <div class="input-group-btn">
                                <button type="submit" name="submit" id="submit" class="btn btn-success btn-lg">
                                    <span class="glyphicon glyphicon-plus"></span></button>
                            </div>
                        </div>
                    </form>
                    <br />
                    <div class="list-group">
                <?php
                    foreach($result as $row) {
                        $style = '';
                        if($row["task_status"] == 'yes') {
                            $style = 'text-decoration: line-through';
                        }
                        echo '<a href="#" style="'.$style.'" class="list-group-item" id="list-group-item-'.
                            $row["task_list_id"].'" data-id="'.$row["task_list_id"].'">'.$row["task_details"].
                            ' <span class="badge" data-id="'.$row["task_list_id"].'">X</span></a>';
                    }
                ?>
                    </div>
                </div>
            </div>
        </div>
    </body>
    </html>

    <script>
    $(document).ready(function(){
    <?PHP if ($lang == '_de') {  ?>
        $(document).find('.english').hide(function() {
             $( document ).find('.german').show(); 
        });
    <?PHP } else { ?>
        $( document ).find('.german').hide(function() {
             $( document ).find('.english').show();
        });
    <?PHP } ?>
       $(document).on('submit', '#to_do_form', function(event){
            event.preventDefault();
            if($('#task_name').val() == '') {
                $('#message').html('<div class="alert alert-danger">Enter Task Details</div>');
                return false;
            } else {
                $('#submit').attr('disabled', 'disabled');
                $.ajax({
                    url:"add_task.php",
                    method:"POST",
                    data:$(this).serialize(),
                    success:function(data) {
                        $('#submit').attr('disabled', false);
                        $('#to_do_form')[0].reset();
                        $('.list-group').prepend(data);
                    }
                })
            }
        });
        $(document).on('click', '.list-group-item', function(){
            var task_list_id = $(this).data('id');
            $.ajax({
                url:"update_task.php",
                method:"POST",
                data:{task_list_id:task_list_id},
                success:function(data) {
                    $('#list-group-item-'+task_list_id).css('text-decoration', 'line-through');
                }
            })
        });
        $(document).on('click', '.badge', function(){
            var task_list_id = $(this).data('id');
            $.ajax({
                url:"delete_task.php",
                method:"POST",
                data:{task_list_id:task_list_id},
                success:function(data) {
                    $('#list-group-item-'+task_list_id).fadeOut('slow');
                }
            })
        });
    });
    </script>
