<?php
/*
 * link_checker.php
 * 
 * Copyright 2021 Hans Lackner <hans@NB-HP>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * 
 */
//require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");
$all = (isset($_GET) and $_GET["show"] == 'all') ? true : false;

	function test_url( $p_url ) {
//		write_log('MSG',"testing '$p_url'");
		return (($fp = @fopen($p_url, 'r')) === false) ? false : @fclose($fp);
	}
	function send_error_email( $p_url, $expert, $s_url ) {
		write_log('MSG',"error email sent to $expert ('$s_url') concerning product email 'p_url'");
		return true;
	}


?>
<!DOCTYPE html>
<html lang="<?=LANG?>">
	
<head>
	<title>smartSPE Link Checker</title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner"> 
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
	
	<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/DataTables/1.11.3/css/dataTables.bootstrap.min.css">
	<link rel="stylesheet" href="assets/Responsive/2.2.9/css/responsive.bootstrap.min.css">
	<link rel="stylesheet" href="assets/fixedheader/3.2.0/css/fixedHeader.bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">

	<script src="assets/jquery/3.5.1/jquery.min.js"></script>
	<script src="assets/bootstrap/js/bootstrap.min.js"></script>

	<style media="screen" type="text/css">
		td {
			max-width: 250px;
			white-space: nowrap;
			overflow: hidden;
			text-overflow: ellipsis;
		}
	</style>
</head>

<body>
	<header>
		<nav class="navbar navbar-light navbar-expand-md bg-white pt-1 pb-1">
			<div class="container-fluid">
				<a class="navbar-brand logo"  target="_blank" href="$spe_link">
					<img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width: 300px"></a>
				<h2>Link Checker</h2>
				<nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
					<div class="container">
						<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
							<span class="sr-only">Toggle navigation</span>
							<span class="navbar-toggler-icon"></span>
						</button>
						<div class="collapse navbar-collapse" id="navcol-1">
							<span class="navbar-text actions"> 
								<button class="btn btn-primary btn-w100 admin" onClick="location.href = 'admin.php' "><?= ADMIN ?></button>
								<button class="btn btn-primary btn-w100 guest" onClick="location.href = 'product.php' "><?= PRODUCT ?></button>
								<button class="btn btn-warning btn-w100 guest" onClick="location.href = 'home.php' ">Home</button>
							</span>
						</div>
					</div>
				</nav>
			</div>
		</nav>
	</header>
<!-- -------------------------- Link checker content ----------------------- -->
<div id="content col-md-12">
	<table>
<!--<table id='checker_table' class='table table-striped table-bordered nowrap' style='width:100%; white-space: nowrap;'>	 style='overflow: hidden; textOverflow: ellipsis; maxWidth: 0'
	<table id='checker_table' class='display dataTable responsive nowrap' width='100%') > style='width:100%; overflow: hidden; white-space: nowrap; textOverflow: ellipsis; maxWidth: 0; '	-->
	<table id='checker_table' class='table table-striped table-bordered nowrap' >

        <thead class='table-dark'>
			<tr><th>No</th>
				<th>Produkt</th>
				<th>Status</th>
				<th>Product</th>
				<th>State</th>
				<th>Supplier</th>
				<th>expert</th>
			</tr>
        </thead>
        <tbody>
<?php
	flush();
	$res = $products_db->query("SELECT id, a5_pr_de, a5_pr_en, a6_supp, a7_ref_de, a7_ref_en FROM smartSPE.product") or die("no links");
	for ($i = 0; $i < 1; $i++) $res->fetch_assoc();								//	jump over first enties
	for ($i = 0; $row = $res->fetch_assoc() /* and $i < 60 */ ; $i++) { 
		$link_state_de = 'n.a.';
		$link_state_en = 'n.a.';
		$prod_url_de = $row['a5_pr_de'];
		$prod_url_en = $row['a5_pr_de'];
		$supp_url = 'n.a.';
		if (filter_var($row['a7_ref_de'], FILTER_VALIDATE_URL) === FALSE) $link_state = 'no supplier';
		if ($supp = $products_db->query("SELECT Expert, Email FROM supplier WHERE Supp_id = '{$row['a6_supp']}';") ) {
			if ($supi = $supp->fetch_assoc() ) {
				$supp_url = "<a href='mailto:".$supi["Email"]."' >".$supi["Expert"]."</a>";
				
				if ( test_url($row['a7_ref_de']) ) {	
					$link_state_de = "<span style='color: green' >link o.k.</span>";
					$prod_url_de = "<a href='".$row["a7_ref_de"]."' >".$row["a5_pr_de"]."</a>";
					write_log('MSG',"link  o.k. '{$row['a5_pr_de']}' ");
				} else { 
					$link_state_de = "<span style='color: red' >link error</span>";
					send_error_email( $row['a7_ref_de'], $supi['Expert'], $supi['Email']); 
					write_log('ERR',"link  error '{$row['a5_pr_de']}' ");
				}
				if ( test_url($row['a7_ref_en']) ) {	
					$link_state_en = "<span style='color: green' >link o.k.</span>";
					$prod_url_en = "<a href='".$row["a7_ref_en"]."' >".$row["a5_pr_en"]."</a>";
					write_log('MSG',"link  o.k. '{$row['a5_pr_en']}' ");
				} else { 
					$link_state_en = "<span style='color: red' >link error</span>";
					send_error_email( $row['a7_ref_en'], $supi['Expert'], $supi['Email']); 
					write_log('ERR',"link  error '{$row['a5_pr_de']}' ");
				}
			} else {
				$link_state_de = "<span style='color: red' >expert email defekt</span>";
				$link_state_en = "<span style='color: red' >expert email defekt</span>";
				write_log('ERR',"email of expert defekt '{$row['a5_pr_de']}' ");
			}
		} else {
			$link_state_de = "<span style='color: red' >no supplier</span>";
			$link_state_en = "<span style='color: red' >no supplier</span>";
			write_log('ERR',"no supplier '{$row['a5_pr_de']}' ");
		}	
		if (strpos($link_state_de, 'o.k.') == false or strpos($link_state_en, 'o.k.') == false or $all) {	?>
			<tr><td><?= $row['id'] ?></td>
				<td><?= $prod_url_de ?></td>
				<td><?= $link_state_de ?></td>
				<td><?= $prod_url_en ?></td>
				<td><?= $link_state_en ?></td>
				<td><?= $row['a6_supp'] ?></td>
				<td><?= $supp_url ?></td>
			</tr>
<?php	}
		flush();
	} ?>
        </tbody>
	</table>
</body>

</html>
