<?php
ob_implicit_flush(true);
///	ini_set("error_log", "/tmp/php-error.log");
/*
 * *************************** maintenance.php *********************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * *****************************************************************************
 *
 * *****************************************************************************
 * backup.php
 * this backup is called from admin.
 * it includes assets/php/backup.php, which may be called by crontab.
 * *****************************************************************************
 */
// echo("<pre>"); print_r($_GET); echo("</pre>");
// echo("<pre>"); print_r($allowed_hosts); echo("</pre>");

/* ****************************** backup database *****************************/
									// ------------------ database parameter ---
	$db_tabs = (isset($_GET["backup_db"])) ? $_GET["backup_db"] : 'all';
	$db_serv = (isset($_GET["server_db"])) ? $_GET["server_db"] : "$host";
	$db_file = ($db_tabs == 'all') ? "{$web_base}.sql" : "{$web_base}_{$db_tabs}.sql";
	$db_tabl = ($db_tabs == 'all') ? '' : $db_tabs;
// echo("start backup on $host<br>");
	$cmd = "mysqldump --host='$host' --user='{$db_prms['usr']}' --password='{$db_prms['pwd']}' $web_site $db_tabl > $db_file";
// echo("$cmd<br>");	
	shell_exec($cmd);
	if (file_exists($db_file) && filesize($db_file) > 100) {
		$msg = write_log('MSG',"admin backup_db - smartSPE DB dumped to $db_file",
							   "admin backup_db - smartSPE DB gesichert nach $db_file" );
		shell_exec("chmod 775 $db_file");
		echo("$msg<br>");
	} else {
		$msg = write_log('ERR','admin backup_db - smartSPE DB dump error',
							   'admin backup_db - smartSPE DB Dump Fehler' );
		echo("$msg<br>");
		exit(0);
	}
/* *************************** end for tables only ****************************/

	if ($db_tabs !== 'all') exit(0);

/* ****************************** zip website *********************************/
									// ----------------------- zip parameter ---
	$zip_name   = "$web_base.zip";
	$cmd = "cd {$web_path} && zip -r -q {$web_site}.zip $web_site.sql $web_site/";
// echo("$cmd<br>");
	$res = shell_exec($cmd);
	shell_exec("chmod 775 $zip_name");
	if (file_exists("$zip_name") && filesize("$zip_name") > 100) {
		$msg = write_log('MSG',"admin backup_db - smartSPE website zipped to $zip_name",
							   "admin backup_db - smartSPE Website zipped nach $zip_name" ); 
		echo("$msg<br>");
	} else {
		$msg = write_log('ERR',"admin backup_db - zip smartSPE DB to $zip_name failed",
							   "admin backup_db - Zip smartSPE DB to $zip_name Fehler" );
		echo("$msg<br>");
		exit(0);
	}
/* **************************** copy zipped website ***************************/
									// -------- backup destination parameter ---
	$dst_host = 'qoscom.de';
	$dst_path = '/var/www/Backups/';
	$dst_user = 'hansi';
	$dst_pass = 'AF0X0$3bm!rJ';
	$dst_from = ( $host == 'nb-hp' ) ? 'QOS' : 'SPE';
	$dst_maxB = 5;

	$dat = date('ymd');
	$dst_file = "{$dst_path}{$dat}_{$dst_from}_{$web_site}.zip";    // "/var/www/Backups/2023-09-14_SPE_smartSPE.zip"

define("SDH2",true);
if (SDH2) {                     // ------------------------ use sdh2_connect ---
	if (!function_exists("ssh2_connect")) die("function ssh2_connect doesn't exist");
/*
function my_ssh_disconnect($reason, $message, $language) {
  printf("Server disconnected with reason code [%d] and message: %s\n",
         $reason, $message);
}

$methods = array(
  'kex' => 'diffie-hellman-group1-sha1',
  'client_to_server' => array(
    'crypt' => '3des-cbc',
    'comp' => 'none'),
  'server_to_client' => array(
    'crypt' => 'aes256-cbc,aes192-cbc,aes128-cbc',
    'comp' => 'none'));

$callbacks = array('disconnect' => 'my_ssh_disconnect');

$conn = ssh2_connect($dst_host, 22, $methods, $callbacks);
*/
//    $conn = ssh2_connect($dst_host, 22, [ 'hostkey' => 'ssh-rsa'] );
    $conn = ssh2_connect($dst_host, 22, [ 'hostkey' => 'ecdsa-sha2-nistp256,ssh-rsa'] );

	if (!$conn) {
		$msg = write_log("ERR",	"backup - can not connect to $dst_host",
					"backup - keine Verbindung zu $dst_host");
		echo("$msg<br>");
		exit(0);
	}
	if ( !ssh2_auth_password($conn, $dst_user, $dst_pass) ) {
		$msg = write_log("ERR",	"backup - failed to connect to $dst_host",
					"backup - Fehler bei der Verbindung zu $dst_host");
		echo("$msg<br>");
		exit(0);
	}
	$sftp = ssh2_sftp($conn);
	$sftp_fd = intval($sftp);

	$dirHdl = opendir("ssh2.sftp://$sftp_fd/$dst_path");
    
	$hasFiles = false;
	while (false !== ($file = readdir($dirHdl))) {
		if ($file != '.' && $file != '..') {
                        $hasFiles = true;
			$files[] = $file;
// echo "$file<br>";
		}
	}
        if ($hasFiles) {
		sort($files);
		$to_del = count($files) - $dst_maxB;
		foreach ($files as $file) {
			if ($to_del > 0) {
				ssh2_sftp_unlink($sftp, "{$dst_path}{$file}");
				$to_del -= 1;
				$msg = write_log("WRN","backup - $file deleted (no of backup exceeded)",
								   "backup - $file gelöscht (Anzahl der Backup überschritten");
				echo("$msg<br>");
			}
		}
	}
// echo("ssh2_scp_send($conn, $zip_name, $dst_file, 0775)<br>");
	if (ssh2_scp_send($conn, $zip_name, $dst_file, 0775) ) {
		$cmd = "sudo chown www-data:www-data $dst_file";
// echo("$cmd<br>");
		$res = ssh2_exec($conn, $cmd);
// echo("res: $res<br>");
		$msg = write_log('MSG',"backup - smartSPE database and website saved in $dst_file",
							   "backup - smartSPE Datenbank und Website gesichert in $dst_file" );
		echo("$msg<br>");
	} else {
		$msg = write_log("ERR","backup - failed to copy website to $dst_host, $dst_file",
							   "backup - Fehler beim kopieren der Website nach $dst_host, $dst_file");
		echo("$msg<br>");
	}
} else {                        // -------------------------------- exec scp ---
    $cmd = "scp /var/www/{$web_site}.zip $dst_user@$dst_host:$dst_file";
//  $cmd = "scp /var/www/smartSPE.zip hans@qoscom.de:/var/www/Backups/20230914_SPE_smartSPE.zip";
echo("$cmd<br>");
    exec($cmd, $output);
print_r($output);echo("<br>");
}
echo("backup finished<br>");
?>
