<?php
/*
 * Anwendung_verkabeln
 * 
 * Wir haben nun alle notwendigen Komponenten entwickelt, die wir brauchen, 
 * um unsere finale Anwendung daraus zu konstruieren, die wir in der index.php-Datei speichern. 
 * Zuerst binden wir unsere Submodule ein, dann stellen wir eine Datenbank-Verbindung her. 
 * Du musst natürlich die Datenbank-Zugangsdaten durch deine eigenen ersetzen 
 * und die Datenbank-Tabelle wie ganz oben beschrieben vorher erstellt haben. 
 * Wenn das geschehen ist, initialiseren wir die Persistenz-Schicht, indem wir das TodoItemRepository erstellen. 
 * Das selbe machen wir für den TodoListView und den TodoController. 
 * Dabei müssen wir die entsprechenden Parameter an die Konstruktoren übergeben. 
 * Der TodoController bekommt zum Beispiel sowohl das TodoItemRepository als auch den TodoListView übergeben. 
 * Dieser Vorgang nennt sich Dependency-Injection. 
 * Wenn alles verkabelt ist, rufen wir die indexAction-Methode unseres Controllers auf 
 * und übergeben ihm das $_POST-Array, das die Formulardaten enthält. 
 * Dann müssen wir das Formular nur noch mit echo ausgeben.
 */
declare(strict_types=1);

use \SelfHtml\Todo\Persistence\TodoItemRepository;
use \SelfHtml\Todo\View\TodoListView;
use \SelfHtml\Todo\Controller\TodoController;

require_once('src/Domain/TodoItem.php');
require_once('src/Persistence/TodoItemResource.php');
require_once('src/Persistence/TodoItemRepository.php');
require_once('src/View/TodoListView.php');
require_once('src/Controller/TodoController.php');

// Konfiguration auslesen
$dsn = 'mysql:host=localhost;dbname=smartSPE';
$username = 'root';
$password = 'Warrior';

// Persistenz-Schicht initialisieren
$pdo = new PDO($dsn, $username, $password);
$repository = new TodoItemRepository($pdo);

// View initialisieren
$view = new TodoListView();

// Controller initialisieren
$controller = new TodoController($repository, $view);

// Controller ausführen und den Rückgabewert ausgeben
echo $controller->indexAction($_POST);

