<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//ini_set('error_reporting', E_ALL);
//error_reporting(E_WARNING);
/*
 * ****************************** user.php *************************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 */
require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");

$msg  = (isset($_GET['msg']))  ? $_GET['msg']  : '';

if (isset($_GET)) {
    $backup_file = "backup/Database/smartSPE.sql";
	foreach ( $_GET as $key => $val ) {
		switch ($key) {
        case 'msg':
            $msg = $val;
            break;
		case 'act':
			$sql = "UPDATE accounts SET state = 'act' WHERE id=$val";
			$run = $products_db->query($sql);
			$msg = write_log('MSG', "user no. $val activated.", "Benutzer Nr. $val aktiviert.");
			break;
		case 'new':
			$msg = write_log('WRN', 'Not implemented, please use register at login.', 'Nicht implementiert. bitte Registrieren in Login verwenden');
			break;
		case 'save':
//echo("<pre>"); print_r($_POST); echo("</pre>");
			$msg = replace_short();
			break;
		case 'del':
			$sql = "SELECT * FROM accounts WHERE id=$val";
			$res = $products_db->query($sql);
			$row = $res->fetch_assoc();
			if ($row["state"] == 'del' or $row["state"] == 'tmp') { 
				$sql = "DELETE FROM accounts WHERE id=$val LIMIT 1";
				if ($res = $products_db->query($sql)) {
					$msg = write_log('WRN', "user no $val permanently deleted.", "Benutzer Nr. $val permanent gelöscht.");
				} else {
					$msg = write_log('ERR', 'DB error: '.mysqli_error($products_db)."\n $sql", 'DB Fehler: '.mysqli_error($products_db)."\n $sql");
				}
			} else {
				$sql = "UPDATE accounts SET state = 'del' WHERE id=$val";
				if ($res = $products_db->query($sql)) {
					$msg = write_log('MSG', "user no $val flagged as deleted.", "Benutzer Nr. $val als gelöscht markiert.");
				} else {
					$msg = write_log('ERR', 'DB error: '.mysqli_error($products_db)."\n $sql", 'DB Fehler: '.mysqli_error($products_db)."\n $sql");
				}
//				exit();
			}
			break;
		default:
            $msg = write_log("ERR","user default - Invalid request.","user default- Falscher Request.");
			break;
		}
	}
}
$spe_link = ($lang == '_en') ? 'https://www.single-pair-ethernet.com' : 'https://www.single-pair-ethernet.de';
?>
<!DOCTYPE html>
<html lang="<?=LANG?>">
	
<head>
	<title>smartSPE <?=USER?></title>
	<meta name="description" content="<?=UMAN?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">

	<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/DataTables/1.11.3/css/dataTables.bootstrap.min.css">
	<link rel="stylesheet" href="assets/Responsive/2.2.9/css/responsive.bootstrap.min.css">
	<link rel="stylesheet" href="assets/fixedheader/3.2.0/css/fixedHeader.bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">

    <script src="assets/jquery/3.5.1/jquery.min.js"></script>
	<script src="assets/bootstrap/js/bootstrap.min.js"></script>
	<script src="assets/DataTables/1.11.3/js/jquery.dataTables.min.js"></script>
	<script src="assets/DataTables/1.11.3/js/dataTables.bootstrap.min.js"></script>
    <script src="assets/fixedheader/3.2.0/js/dataTables.fixedHeader.min.js"></script>
    <script src="assets/Responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="assets/Responsive/2.2.9/js/responsive.bootstrap.min.js"></script>

   	<script>
		$(document).ready(function() {
			var userTable = $('#user_table').DataTable( {
				responsive: 	true,
				dom: 			'rtp',	// B-utton,f-ind,p-r-ocess,t-able,l-ength,i-nfo,p-agination
/*				scrollY:        "500px",// without paging
				scrollX:        true,
				scrollCollapse: true,
				paging:         true,
*/				paging:         false,
				fixedColumns:   {  heightMatch: 'none' }
			} );
			new $.fn.dataTable.FixedHeader( userTable );
			userTable.columns.adjust().draw();
		} );
		function action(act) { 		// *************** act=del, act, new sav ***
			usr_id = document.getElementById("id").value;
			if (act == "del") alert("really delete user no: "+usr_id);
			document.forms['user_modal'].action = "user.php?"+act+"="+usr_id;
			document.forms['user_modal'].submit();
		}
	</script>
    <style>	.table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th { padding:0; } </style>

</head>
      
<body class="d-flex flex-column min-vh-100">
<!-- ------------------------- Page header ------------------------- -->
<header>
    <nav class="navbar navbar-light navbar-expand-md bg-white pt-1 pb-1">
		<div class="container-fluid">
            <a class="navbar-brand logo"  target="_blank" href="$spe_link">
                <img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width: 300px"></a>
            <h2><?= UMAN ?></h2>
			<nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
                <div class="container">
					<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
						<span class="sr-only">Toggle navigation</span>
						<span class="navbar-toggler-icon"></span>
					</button>
                    <div class="collapse navbar-collapse" id="navcol-1">
                        <span class="navbar-text actions"> 
							<button class="btn btn-primary btn-w100 admin" onClick="location.href = 'admin.php' "><?= ADMIN ?></button>
							<button class="btn btn-primary btn-w100 guest" onClick="location.href = 'product.php' "><?= PRODUCT ?></button>
							<button class="btn btn-warning btn-w100 guest" onClick="location.href = 'home.php' ">Home</button>
						</span>
					</div>
                </div>
            </nav>
		</div>
	</nav>
</header>
<!-- --------------------------------- userModal --------------------------- -->
<div class="modal fade" id="userModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content bg-secondary">	<!----- Modal content ----->
            <div class="modal-body">

            </div>
			<div class="text-center" >
				<div class="btn-group" role="group">
					<button type="button" class="btn bg-warning" onClick="action('act');" > Activate </button>
					<button type="button" class="btn bg-success text-white" onClick="action('new');" > New </button>
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn bg-primary text-white" onClick="action('save');" > Save </button>
					<button type="button" class="btn bg-danger text-white" onClick="action('del');" > Delete </button>
				</div>
			</div>
        </div>
    </div>
</div>
<!-- --------------------------------- msgModal ---------------------------- -->
<?PHP	
	require_once ("assets/php/message.php");
	if ( !empty($msg) ) { 
?>	<script>
		$('#msgModal').modal("show");
		var newURL = location.href.split("?")[0];
		window.history.pushState('object', document.title, newURL);
	</script>
<?PHP }	?>
<!-- ----------------------- Accounts Table  Header ------------------------ -->
<content>
    <main class="products">
        <div class="row m-3">

			<form id='edit_line' name='edit_line' method='POST' ></form>
			<table id='user_table' class='table table-striped  table-hover table-bordered nowrap' style='width:100%'>
			<thead class='table-dark'>
 		        <tr><th>ID</th>  
		            <th>User</th>  
		            <th>Usr_id</th>  
		            <th>Avatar</th>  
		            <th>Email</th>  
		            <th>Company</th>  
		            <th>start_page</th>  
		            <th>rights</th>  
		            <th>state</th>  
		            <th>potm</th>  
		            <th>v_no</th>  
		            <th>v_sta</th>  
		            <th>act</th>  
		        </tr>  
			</thead>  
<!-- -------------------- Accounts Table  Body --------------------- -->
<?php	$sql = "SELECT * FROM accounts";  
		$res = $products_db->query($sql);  
		while($row=$res->fetch_assoc()) {
?>
			<tbody>
				<tr id="tr_<?= $row["id"] ?>" class="<?= $row['state'] ?>" onDblClick="mark_selected_user('<?= $row["id"] ?>')" >
					<td><button class='btn btn-w80 btn-primary' value="<?= $row["id"] ?>" onClick="copy_to_edit_row('<?= $row["id"] ?>')"  
						data-toggle = 'popover' title = 'Edit user' ><?= $row["id"] ?></button></td>
		            <td><?= $row['user'] ?></td>  
		            <td><?= $row['usr_id'] ?></td>  
		            <td><?= $row['avatar'] ?></td>  
		            <td><?= $row['email'] ?></td>  
		            <td><?= $row['company'] ?></td>  
		            <td><?= $row['start_page'] ?></td>  
		            <td><?= $row['rights']  ?></td>
		            <td><?= $row['state'] ?></td>  
		            <td><?= $row['v_potm'] ?></td>  
		            <td><?= $row['v_no'] ?></td>  
		            <td><?= $row['v_state'] ?></td>  
<?PHP		if ($row['state'] == 'ack') { ?>
					<td><button class='btn btn-w60 btn-success' onClick="location.href = ' user.php?act=<?=$row['id']?>' " >act</button></td>
<?PHP		} if ($row['state'] == 'act' or $row['state'] == 'del' or $row['state'] == 'tmp') { ?>
					<td><button class='btn btn-w60 btn-warning' onClick="ask_del('<?= $row["id"] ?>') " >del</b></button></td>
<?PHP		}	?>
				</tr>  
<?PHP	}	?>
			</tbody>
<?php	$sql = "SELECT max(`id`) as `max_user` FROM `accounts`";
		$res = $products_db->query($sql) or die(mysqli_error($products_db));
		$row=$res->fetch_assoc();
		$next_user = $row["max_user"] + 1;
?> 
<!-- ------------------------------ User Table Footer ---------------------- -->
			<tfoot class="table-warning">
				<tr><td class='col-sm-1'><input type='text' id='id' 		name='id' 		value="<?= $next_user?>"class='col-sm-12' form='edit_line' /></td>  
					<td class='col-sm-2'><input type='text' id='user'		name='user'		placeholder='user'		class='col-sm-12' form='edit_line' /></td>  
					<td class='col-sm-1'><input type='text' id='usr_id'		name='usr_id' 	placeholder='usr_id'	class='col-sm-12' form='edit_line' /></td>  
					<td class='col-sm-2'><input type='text' id='avatar'  	name='avatar'	placeholder='avatar'	class='col-sm-12' form='edit_line' /></td>  
					<td class='col-sm-2'><input type='text' id='email'		name='email' 	placeholder='email' 	class='col-sm-12' form='edit_line' /></td>  
					<td class='col-sm-2'><input type='text' id='company'	name='company'	placeholder='company'	class='col-sm-12' form='edit_line' /></td>  
					<td><select name="start_page" id="start_page" form='edit_line' >
							<option value=""> </option>
							<option value="index.php">index.php</option>
							<option value="home.php" selected>home.php</option>
							<option value="admin.php">admin.php</option>
						</select>
					</td>
					<td><select name="rights" id="rights" form='edit_line' >
							<option value="super">super</option>
							<option value="admin">admin</option>
							<option value="member" selected >member</option>
							<option value="guest">guest</option>
							<option value="voter">voter</option>
						</select>
					</td>  
					<td><select name="state" id="state" form='edit_line' >
							<option value="tmp" >tmp</option>
							<option value="ack" >ack</option>
							<option value="act">act</option>
							<option value="del">del</option>
							<option value="vote">vote</option>
						</select>
					<td ><input type='text' id='v_potm'	name='v_potm'		placeholder='22-01'	class='col-sm-12' form='edit_line' /></td>  
					<td ><input type='text' id='v_no'	name='v_no'			placeholder='1'		class='col-sm-12' form='edit_line' /></td>  
					<td ><input type='text' id='v_state'	name='v_state' 	placeholder='cnt'	class='col-sm-12' form='edit_line' /></td>  
					</td>
					<td><button class='btn btn-w60 btn-primary' data-toggle='popover' title='Update or add a user' onClick='user_save()'form='edit_line' >save</button></td>
				</tr>
			</tfoot>  
   			</table>  
		</div>
	</main>
</content>
    
<?php require_once ('assets/php/footer_small.php'); ?>

<script>
    var lang  = "<?=$_SESSION["lang"]?>";
    var right = "<?=$_SESSION["rights"]?>";
    
    function user_save() {				// ----------------------- save user ---
		var id	 = $('#id')[0].value;
		var confText = (lang =='_de')	? "Aufgabe "+id+" ändern oder hinzufügen?"
										: "Really change or add user "+id+" ?";
		var r = confirm(confText);
		if (r == true) {
			$('#edit_line')[0].action = "user.php?save="+id;
			$('#edit_line')[0].submit();
		}
	}								
	function copy_to_edit_row(row_id) {	// - copy selected vote to edit line ---
		var tr = $('#tr_'+row_id)[0];

		var tbl 	= $('#user_table')[0];
		var tbl_lng	= tbl.rows.length;
		var row_lng = tbl.rows[tbl_lng - 1].cells.length;
		var dst_row	= tbl.rows[tbl_lng - 1];

		document.forms.edit_line.elements[0].value = tr.id.substr(3);
//console.log(document.forms.edit_line.elements[0].id+" = "+tr.id.substr(3) );
		for (var i = 1; i < row_lng - 1; i++) {
			if (dst_row.cells[i].getElementsByTagName('input')[0]) {
				document.forms.edit_line.elements[i].value = tr.cells.item(i).innerHTML;
//console.log(document.forms.edit_line.elements[i].id+" = "+tr.cells.item(i).innerHTML );
				continue;
			}
			if (dst_row.cells[i].getElementsByTagName('select')[0]) {
				id = dst_row.cells[i].getElementsByTagName('select')[0].id;
				val = tr.cells.item(i).innerHTML;
				document.getElementById(id).value = val;
				continue;
			}
		}
		document.getElementById("id").focus();
	}
	function mark_selected_user(id) { 	// -------------- mark_selected_user ---
		$('.modal-body').load('user_modal_content.php?id=' + id,
			function() { $('#userModal').modal( {show:true} ); } );
	}
	function ask_del(id) {				// ------------------ ask for delete ---
		var confText = (lang =='_de')	? "Benutzer "+id+" wirklich löschen?" : "Really delete user "+id+" ?";
		var r = confirm(confText);
		if (r == true) { document.location.href = 'user.php?del='+id }
	}								

</script>

<script src="assets/js/display.js"></script>
    

</body>    
</html>
