<?php
ini_set('display_errors',1); 
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/*
 * ****************************** user_ajax.php ********************************
 *
 * Copyright 2022 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * *****************************************************************************
 * 
 * smartSPE server-side user processing
 * 
 * $_POST = $_SESSION["post"];
 * $_SESSION["post"] = $_POST;
 * echo("<pre>"); print_r($_POST); echo("</pre>");
 *
 * *****************************************************************************
 */
if(session_id() == ''){ session_start(); }
require_once ("assets/php/global.php");
require_once ("assets/php/globals_product.php" );

	if ($_SESSION["lang"] == "_de") require_once("assets/php/index_de.php");
	else require_once("assets/php/index_en.php");

	$request = (!empty($_POST["request"])) ? $_POST["request"] : 99;
	write_log("DEB","product_ajax - request: $request");
/*
 * ************************** ajax request switch ******************************
 */
switch ($request) {
	case "login":	{
									// ******************************* login ***
		$email 	= (isset($_POST['email'])) ? $_POST['email'] : false;
		$pass	= (isset($_POST['password'])) ? $_POST['password'] : false;
		$cat_id	= (isset($_POST["cat_id"])) ? $_POST["cat_id"] : false;
		$do_chat= (isset($_POST["do_chat"]) and $_POST["do_chat"] == 'chat_now') ? true : false;
		$pMD5	= MD5($pass);
		$sql = "SELECT * FROM accounts WHERE email=? AND password=? AND state='act' ";
//die($sql);
$msg = write_log("DEB","$sql, $email, $pass, $pMD5, $cat_id");
		$res = prep_select($products_db, $sql, [ $email, $pMD5 ]);
		if (mysqli_num_rows($res) > 0 ) {
			$row = $res->fetch_assoc();
			$_SESSION['username']= $row['user'];
			$_SESSION['usr_id']	= $row['usr_id'];
			$_SESSION['userid']	= $row['id'];
			$_SESSION['state'] 	= 'logged-in';
			$_SESSION['email'] 	= $row['email'];
			$_SESSION['rights']	= $row['rights'];
			$_SESSION['current_session'] = 2;
			$_SESSION['online'] = 1;
			$start_page	= ($cat_id) ? "product.php" : $row['start_page'];
			if ($do_chat) $start_page = "chat.php";
			$msg = write_log("MSG", LOGIN_ACK.$_SESSION['username']);
			echo json_encode( array("status" => 1, "msg" => $msg, "cat" => $cat_id, "start_page" => $start_page ) );
			exit();
			break;
		} // else {
			$msg = write_log("ERR",LOGIN_ERR);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
//		}
		exit; 
	} break;
 	case "logout": {				// ****************************** logout ***
		$_SESSION['state'] 	= 'logged-out';
		unset($_SESSION['username']);
		unset($_SESSION['usr_id']);
		unset($_SESSION['email']);
		unset($_SESSION['rights']);
		$msg = write_log("MSG", GOOD_BY);
		header("Location: index.php?msg=$msg");
		exit();
	} break;
 	case "register": {				// **************************** register ***
											// ---- check required parameter ---
		if(!(isset($_POST['user']) && isset($_POST['company']) && isset($_POST['email']) && isset($_POST['password'])) ) {
			$msg = write_log("ERR",	REG_UNCMP);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
			exit(); break;
		}
											// --- check password complexity ---
		if (preg_match("/^.*(?=.{8,})(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z]).*$/", $_POST["password"]) === 0) {
			$msg = write_log("ERR",PWD_INV);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
			exit(); break;
		}
		$user	= $_POST['user'];  
		$comp	= $_POST['company'];  
		$email	= $_POST['email'];  
		$pass	= MD5($_POST['password']);

											// --- does email account exist? ---
$msg = write_log("DEB","SELECT * FROM accounts WHERE email='$email' ");
		$sql = "SELECT * FROM accounts WHERE email=?";
		$res = prep_select($products_db, $sql, [$email] );
		$pend = '';
		$voter = false;
		if ($row = $res->fetch_assoc()) {
/* -------------------------
			if ($row["state"] == 'pend') {
				$pend = REG_ACT."<br>";
			} else { 
				if ($row["state"] == 'act') {
					$msg = write_log("ERR", ACC_EXIST); 
				} else {
					if ($row["state"] == 'ack') {
						$msg  = write_log("MSG", REG_ACK);
					} else {
						$msg = write_log("ERR", AD_IN_USE);
					}
				}  
				echo json_encode( array("status" => 0, "msg" => $msg ) );
				exit(); break;
			}
----------------------- */
			$msg = '';
			$pend = '';
			switch ($row['state']) {
				case 'pend': $pend = REG_ACT."<br>"; break;
				case 'tmp': $voter = true; break;
				case 'act':	$msg = write_log("ERR", ACC_EXIST); break;
				case 'ack':	$msg = write_log("MSG", REG_ACK); break;
				default: $msg = write_log("MSG", REG_ACK);
			}
			if ($msg) {
				echo json_encode( array("status" => 0, "msg" => $msg ) );
				exit();
			}
		}
// -----------------------------
		$pend_hash = ($pend > '' ) ? $row["pend_hash"] : substr(md5(time()), 0, 45);
											// ---------- user confirm email ---
		$from	= [ $adm["Email"], $adm["Expert"] ];
		$to 	= [$email, $user];
		$reply	= [$spe_noreply_mail, 'No Reply'];
		$link 	= ($voter)	? "<p><a href = '$indx_url?fct=register&email=$email&hash=$pend_hash' >"
							: "<p><a href = '$indx_url?fct=register&email=$email&hash=$pend_hash' >";
		$body 	= ($voter)	? CONF_BODY."$user".UPD_BODY1.$link.CONF_BODY2.$man_sign
							: CONF_BODY."$user".CONF_BODY1.$link.CONF_BODY2.$man_sign;
		if (send_confirm_msg(CONF_SUBJ, $body, $from, $to, $reply)) {
			$words 	= explode(' ', $user);
			$usr_id = (count($words) > 1) ? substr($words[0],0,1).substr($words[1],0,1) : substr($words[0],0,2);
			$usr_id = strtoupper($usr_id);
			$up_id  = $usr_id;
			if ($voter) {
				$sql = "UPDATE accounts SET user=?, usr_id=?, company=?, password=?, start_page=?, rights=?, state=?, pend_hash=?, up_id=?, updated=? WHERE email=?";
				if (prep_query($products_db, $sql, [ $user, $usr_id, $comp, $pass,'home.php', 'guest', 'pend', $pend_hash, $up_id, $now, $email ] ) ) {
					$msg = USER_CREA1.$user.USER_CREA2.$email.USER_CREA3;
					$msg = write_log("MSG", $msg);
					echo json_encode( array("status" => 1, "msg" => "MSG: $pend$msg" ) );
					exit(); break;
				} else {
					$msg = write_log("ERR",ACC_SAVE.mysqli_error($products_db));
					echo json_encode( array("status" => 0, "msg" => $msg ) );
					exit(); break;
				}
			} else {
				$sql = "SELECT max(`id`) as `max_id` FROM `accounts`";
				$res = $products_db->query($sql) or die(mysqli_error($products_db));
				$row = $res->fetch_assoc();
				$nxt_id	= $row["max_id"] + 1;

				$sql 	= "INSERT INTO accounts (`id`,`user`,usr_id,avatar,company,email,password,start_page,state,pend_hash,up_id,updated,cr_id,created) ".
						  "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				if (prep_query($products_db, $sql,
					[ $nxt_id,$user,$usr_id,'user1.jpg',$comp,$email,$pass,'home.php','pend',$pend_hash,$up_id,$now,$up_id,$now ] ) ) {
					$msg = USER_CREA1.$user.USER_CREA2.$email.USER_CREA3;
					$msg = write_log("MSG", $msg);
					echo json_encode( array("status" => 1, "msg" => "MSG: $pend $msg" ) );
					exit(); break;
				} else {
					$msg = write_log("ERR",ACC_SAVE.mysqli_error($products_db));
					echo json_encode( array("status" => 0, "msg" => $msg ) );
					exit(); break;
				}
			}
		} else {
			$msg = write_log("ERR", SEND_ERR);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
			exit(); break;
		}
	} break;
	case "forgot": {				// ****************************** forgot ***
		if (!isset($_POST['email'] )) {		// ---- check required parameter ---
			$msg = write_log("ERR",	NO_EMAIL);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
			exit(); break;
		}
		$email	= $_POST['email'];  

		$sql = "SELECT * FROM accounts WHERE email=? ";
		$res = prep_select($products_db, $sql, [ $email ]);
		if (!$row = $res->fetch_assoc()) {		// --- check if email exists ---
			$msg = write_log("ERR",	NO_ACCOUNT);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
			exit(); break;
		}
		$user = $row["user"];
		$pend_hash = substr(md5(time()), 0, 45);
												// -- send forgotten message ---
		$from	= ['register@QoSCom.de', 'SPE Service'];
		$to 	= [$email, $user];
		$reply	= ['noreply@QoSCom.de', 'No Reply'];
		$link	= "<p><a href = '$indx_url?fct=renew&hash=$pend_hash&email=$email' >";
		$body 	= FRGT_BODY.$user.FRGT_BODY1.$link.FRGT_BODY2.$man_sign;
		if (send_confirm_msg(FRGT_SUBJ, $body, $from, $to, $reply)) {
			$words 	= explode(' ', $user);
			$usr_id = (count($words) > 1) ? substr($words[0],0,1).substr($words[1],0,1) : substr($words[0],0,2);
			$usr_id = strtoupper($usr_id);
			$up_id  = "NN";
												// ---------- update account ---
			$sql = "UPDATE accounts SET password='',state='ren',pend_hash=? WHERE `email`=? LIMIT 1";
			if (prep_query($products_db, $sql, [ $pend_hash, $email ])) {
				$msg = write_log("MSG", USER_CLR1.$user.USER_CLR2.$email.USER_CLR3);
				echo json_encode( array("status" => 1, "msg" => $msg ) );
			} else { 
				$msg = write_log("ERR",ACC_SAVE);
				echo json_encode( array("status" => 0, "msg" => $msg ) );
			}
		} else {
			$msg = write_log("ERR", SEND_ERR);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
		}
	} break;
	case "renew": {					// ********************** renew password ***
		$email 	= $_POST['email'];
		$pass	= $_POST['passwd'];

		$sql = "SELECT * FROM accounts WHERE email = ? AND state = 'ren' ";
		$row = prep_select($products_db, $sql, [ $email ] )->fetch_all(MYSQLI_ASSOC);
		if(count($row) == 1)  {  
			$pMD5 = MD5($pass);
			$sql = "UPDATE accounts SET password=?, state='act', pend_hash='' WHERE email=? LIMIT 1";
//echo "UPDATE accounts SET password='$pMD5', state='act' pend_hash='' WHERE email='$email' LIMIT 1";
			prep_query($products_db, $sql,[ $pMD5, $email ]) 
				or die(mysqli_error($products_db));
			$msg = write_log("MSG", PASSWD_RES);
			echo json_encode( array("status" => 1, "msg" => $msg ) );
			exit();
			break;
		} else {
			$msg = write_log("ERR",RENEW_ERR);
			echo json_encode( array("status" => 0, "msg" => $msg ) );
		}
		exit; 
	} 	break;
	case "vote": {					// ********* send users vote for confirm ***
		if (!isset($_POST["email"]) ) { 
			$msg = write_log("ERR",NO_EMAIL);
			echo json_encode( array("status" => 0, "message" => $msg ) );
			exit(); break;
		}
		$email 	= $_POST["email"];
		$vote 	= $_POST["vote"];  
		$voteNo = $_POST["voteNo"];  
		$votePN = $_POST["votePN"];  
		$voteCat  = $_POST["voteCat"];  
		$voteProd = $_POST["voteProd"];  
		$voteSupp = $_POST["voteSupp"];  

		$sql = "SELECT * FROM accounts WHERE `email`=?";
		$row = prep_select($products_db, $sql, [ $email ] )->fetch_all(MYSQLI_ASSOC);
		$usr_id= 	"CV";
//		$now =date("Y-m-d H:i:s");
		if (count($row) == 0) {		// ----- no account, so create a tmp one ---
            $res = $products_db->query("SELECT MAX(id) as max_id FROM accounts");
            $max = $res->fetch_assoc(); 					// find the next id in product table
            $nxt_id = $max["max_id"] + 1;
			$user 	= "SPE Voter $nxt_id";
			$usr_id = "V$nxt_id";
			$avatar	= "user3.jpg";
			$start_page="index.php";
			$acc_state=	"tmp";
			$rights=	"vote";
			$sql = "INSERT INTO accounts (id,user,usr_id, avatar,email,company,start_page,state,rights,up_id,updated,cr_id,created) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$res = prep_query($products_db, $sql, [ $nxt_id, $user,$usr_id,$avatar,$email,'voter',$start_page,$acc_state,$rights,$usr_id,$now,$usr_id,$now ] );
			if ($res) {
				$msg = write_log("MSG", "$user ($usr_id) created, $avatar,$email,'voter',$start_page,$acc_state,$rights,$usr_id ");
			} else {
				$msg = write_log("ERR", "$user ($user_id) insert failed, $avatar,$email,'voter',$start_page,$acc_state,$rights,$usr_id ");
				echo json_encode( array("status" => 0, "message" => $msg ) );
				exit(); break;
			}				
		} else {					// ----------------- account nicht aktiv ---
			if ($row[0]["state"] != 'act' and $row[0]["state"] != 'tmp') {
				$msg = write_log("WRN", ACC_INACT."<a href='mailto:{$man["Email"]}' >{$man["Email"]}</a>");
				echo json_encode( array("status" => 0, "message" => $msg ) );
				exit(); break; 				
			}						// ------------------- has already voted ---
			$user = $row[0]["user"];
			if ($row[0]["v_potm"] == $vote and $row[0]["v_state"] == 'cnt' ) {
				$msg = write_log("WRN", ALLR_VOTED);
				echo json_encode( array("status" => 0, "message" => $msg ) );
				exit(); break;
			} 						// ---------------- noch nicht quittiert ---
			$not_cnt = '';
			if ($row[0]["v_potm"] == $vote) {
				$not_cnt = NOT_CNT."<br>";
				write_log("WRN", NOT_CNT);
			}
		}
		$v_state='req';
		$up_id='CV';
		$pend_hash = substr(md5(time()), 0, 45);
												// ------- send vote message ---
		$sql = "UPDATE accounts SET pend_hash=?, v_potm=?, v_state=?, v_no=?, up_id=?, updated=? WHERE email=?";
		$res = prep_query($products_db, $sql, [ $pend_hash, $vote, $v_state, $voteNo, $up_id, $now, $email ] );
		$from	= [ $adm["Email"], $adm["Expert"] ];
		$to 	= [ $email, $user ];
		$reply	= [ $spe_noreply_mail, "No Reply"];
		$link 	= "<a href = '$indx_url?fct=vote&hash=$pend_hash&email=$email' >";
		$body	= VOTE_BODY."$user".VOTE_BODY1.$vote.VOTE_BODY2."$voteNo".VOTE_BODY3.$link.VOTE_BODY4.$man_sign.VOTE_BODY5;
		if (send_confirm_msg(VOTE_SUBJ, $body, $from, $to, $reply)) {
			$msg = write_log("MSG", CONFM_OK.$email);
			echo json_encode( array("status" => 1, "message" => "$msg") );
			exit();	break;
		} else {
			$msg = write_log("MSG", CONFM_ERR);
			echo json_encode( array("status" => 0, "message" => "$msg") );
			exit();	break;
		}
	} 
	default:{						// ** invalid request parameter, default ***
		$msg = write_log("ERR", INV_PARAM);
		echo json_encode( array("status" => 0, "message" => $msg ) );
	}
}
