<?PHP
/*
 * ****************************** home.php *************************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 */
require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");

	$msg  = (isset($_GET['msg']))  ? $_GET['msg']  : '';
?>
<!DOCTYPE html>
<html>

<head>
	<title><?= HOME_HDR ?></title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
    
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">
    <style>
/* remove all roundes edges	*/
		* {	border-radius: 0 !important; }
    </style>

    <script src="assets/jquery/3.5.1/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
</head>

<body class="d-flex flex-column min-vh-100">
<!-- ------------------------------- Page header --------------------------- -->
<header>
    <nav class="navbar navbar-light navbar-expand-md bg-white pt-1 pb-1">
		<div class="container-fluid">
            <a class="navbar-brand logo"  target="_blank" href="<?= SPE_LINK ?>">
                <img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width: 300px"></a>
            <h2><?= HOME_HDR ?></h2>
			<nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
                <div class="container">
					<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
						<span class="sr-only">Toggle navigation</span>
						<span class="navbar-toggler-icon"></span>
					</button>
                    <div class="collapse navbar-collapse" id="navcol-1">
                        <span class="navbar-text actions"> 
							<button class="btn btn-primary btn-w100 admin" onClick="location.href = 'admin.php' "><?= ADMIN ?></button>
<!--							<button class="btn btn-primary btn-w100 guest" onClick="location.href = 'product.php' "><?= PRODUCT ?></button>	-->
							<button class="btn btn-warning btn-w100 guest" onClick="location.href = 'index.php?fct=logout' "><?= LOGOUT ?></button>
                        </span>
					</div>
                </div>
            </nav>
		</div>
	</nav>
</header>

<?PHP require_once ("assets/php/message.php");
	if ( !empty($msg) ) { ?>
	<script>
		$('#msgModal').modal("show");
		var newURL = location.href.split("?")[0];
		window.history.pushState('object', document.title, newURL);
	</script>
<?PHP } ?>
<!-- ------------------------------- Page content -------------------------- -->
<main class="page catalog-page">
	<div class="row">
		<div class="col-md-1"></div>
		<div class="col">
<?PHP			$cat = ($_SESSION["lang"] == '_de') ? 'cat_de' : 'cat_en';
$res = $products_db->query("SELECT * FROM category");
$row = $res->fetch_assoc();
while ( $row = $res->fetch_assoc() ) {	?>
<!--				<li style="width: 190px; float: left;" ><a href = "javascript: document.location.href='product.php?view=<?= $row["id"] ?>'"><?= $row["$cat"] ?></a>  </li>	-->
				<span>|<spacer><a href = "javascript: document.location.href='product.php?view=<?= $row["id"] ?>'"><?= $row["$cat"] ?></a><spacer>|</span>
<?php 			} ?>
		</div>
	</div>
	<div class='row'>
		<!-- ----------------------------------- left column --
		<div class="col-md-2">
			<div class="d-none d-md-block">
				<div class="filters m-3">
					<!-- ------------------------ categories --
					<div class="filter-item m-3">
						<h4><?= CAT_HDR ?></h4>
<PHP			$cat = ($_SESSION["lang"] == '_de') ? 'cat_de' : 'cat_en';
$res = $products_db->query("SELECT * FROM category");
$row = $res->fetch_assoc();
while ( $row = $res->fetch_assoc() ) {	?>
						<div class="form-check">
							<a href = "javascript: document.location.href='product.php?view=<?= $row["id"] ?>'"><?= $row["$cat"] ?></a>;
						</div>
<php 			} ?>
					</div>
									<!-- ------------------------- Protocols --
					<div class="filter-item m-3">
						<h4><= PROTOCOLS ?></h4>
						<select onChange="filterProto(this.value)">
<PHP	$res = $products_db->query("SELECT * FROM protocol");
		while ( $row = $res->fetch_assoc() ) {	?>
							<option value="<?= $row['Protocol'] ?>">
								<?= $row['Protocol'] ?>
							</option>
<PHP			} ?>		            </select>
					</div>
									<!-- -------------------------- Supplier --
					<div class="filter-item m-3">
						<h4><= SUPPLIER ?></h4>
						<select onChange="filterProto(this.value)">
<PHP	$res = $products_db->query("SELECT * FROM `product` WHERE `a6_supp` NOT LIKE 'Manuf%' GROUP BY `a6_supp`");
		while ( $row = $res->fetch_assoc() ) {	?>
							<option value="<?= $row['a6_supp'] ?>"><?= $row['a6_supp'] ?></option>
<PHP			} ?>	</select>
					</div>
				</div>
			</div> 
		</div>
						<!-- --------------------------- three columns right -->
		
		<div class="col-md-12">
						<!-- ---------------------------- modal connectivity -->
			<div class="modal fade" role="dialog" tabindex="-1" id="connectivity">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h4 class="modal-title">Modal Title</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button></div>
						<div class="modal-body">
							<p>The content of your modal.</p>
						</div>
						<div class="modal-footer"><button class="btn btn-light" type="button" data-dismiss="modal">Close</button><button class="btn btn-primary" type="button">Save</button></div>
					</div>
				</div>
			</div>
						<!-- -------------------------------- category cards -->
			<div class="row no-gutters">
<?PHP	$res = $products_db->query("SELECT * FROM category");
		$cat = $res->fetch_assoc();
		$img_empty = 'SPE-Geräte.JPG';
		while ( $cat = $res->fetch_assoc() ) { $img = ( empty($cat['img']) ) ? $img_empty : $cat['img'];  ?>
				<div class="col-12 col-md-6 col-lg-3">
					<div class="clean-product-item">
						<a href="product.php?cat=<?= $cat['id'] ?> ">
							<h4 class="text-center"><?= c2nam($cat['id']) /* ('c1_conn') */ ?></h4>
							<img class="img-fluid d-block mx-auto" style="max-height:150px;max-width:300px;" src="upload/Common/<?= $img ?>">
							<p class='text-center'><?= c2dsc($cat['id']) ?></p>
						</a>
					</div>
				</div>
<?PHP	} ?>                                
			</div>
		</div>
	</div>
</main>
            <!-- --------------------- Page footer ------------------------- -->

<?php require_once ("assets/php/footer_small.php"); ?>

    <script>
        var lang = "<?=$lang?>";
        var right = "<?=$_SESSION["rights"]?>";

        function filterProto(prot) {
            document.location.href='product.php?protocol='+prot;
        }
        function filterSupp(prot) {
            document.location.href='product.php?supplier='+prot;
        }
    </script>
    
    <script src="assets/js/display.js"></script>

</body>
</html>
