<?php
/*
 * ****************************** task.php *************************************
 *
 * Copyright 2021, 2022 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 * 	Task Management
 *
 * echo("<pre>"); print_r($_GET);  echo("</pre>");
 * echo("<pre>"); print_r($_POST); echo("</pre>");
 * echo("<pre>"); print_r($_SESSION); echo("</pre>");
 * 
 * *****************************************************************************
 */

require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");

$msg = (isset($_GET["msg"])) ? $_GET["msg"] : '';

if ( empty($msg) ) {
	foreach ( $_GET as $key => $val ) {
		switch ($key) {
		case 'version':	{
            $act_version = ($val == "Vx_x") ? "%" : $val;
            $sql = "UPDATE `task_list` SET `version` = '$act_version' WHERE `id` = 0 LIMIT 1";
            if (!$res = $products_db->query($sql)) {
				$msg = write_log("ERR","Database Error: ". mysqli_error($products_db) );
            } else { 
				$msg = write_log("MSG","Version $act_version selected","Version $act_version ausgewählt" );
			}
		}	break;
		case 'save':	{
			$msg = create_or_update_task();
		}	break;
		case 'activate':	{
			$sql = "UPDATE task_list SET state = 'active' WHERE id=$val";
			$res = $products_db->query($sql);
			$msg = write_log("MSG"," task no $val active.","Aufgabe Nr. $val aktiv.");
		}	break;
		case 'complete':	{
			$sql = "UPDATE task_list SET state = 'completed', `completed` = '$now' WHERE id=$val";
			$res = $products_db->query($sql);
			$msg = write_log("MSG"," task no $val completed.","Aufgabe Nr. $val erledigt.");
		}	break;
		case 'delete':		{
			$sql = "SELECT * FROM task_list WHERE id=$val";
			$res = $products_db->query($sql);
			$row = $res->fetch_assoc();
			if ($row["state"] == 'deleted') { 
				$sql = "DELETE FROM task_list WHERE id=$val LIMIT 1";
				$res = $products_db->query($sql);
				$msg = write_log("WRN","task no $val permanent deleted.","Aufgabe Nr. $val permanent gelöscht.");
			} else {
				$sql = "UPDATE task_list SET state = 'deleted' WHERE id=$val";
				$res = $products_db->query($sql);
				$msg = write_log("WRN"," task no $val flaged as deleted.","Aufgabe Nr. $val als gelöscht gekennzeichnet.");
				exit();
			}
		}	break;
		default:		{
			header("Location: task.php?msg=WRN not yet implemented");
			exit();
		}	break;
		}
	}
}
$spe_link = ($lang == '_en') ? 'https://www.single-pair-ethernet.com' : 'https://www.single-pair-ethernet.de';
?>
<!DOCTYPE html>
<html lang="<?=LANG?>">
	
<head>
	<title>smartSPE <?=TASK?></title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
	
<!--<link rel="stylesheet" href="assets/bootstrap/3.3.7/css/bootstrap.min.css">-->
	<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/DataTables/1.11.3/css/dataTables.bootstrap.min.css">
	<link rel="stylesheet" href="assets/Responsive/2.2.9/css/responsive.bootstrap.min.css">
	<link rel="stylesheet" href="assets/fixedheader/3.2.0/css/fixedHeader.bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">

    <script src="assets/jquery/3.5.1/jquery.min.js"></script>
	<script src="assets/bootstrap/js/bootstrap.min.js"></script>
	<script src="assets/DataTables/1.11.3/js/jquery.dataTables.min.js"></script>
	<script src="assets/DataTables/1.11.3/js/dataTables.bootstrap.min.js"></script>
    <script src="assets/fixedheader/3.2.0/js/dataTables.fixedHeader.min.js"></script>
    <script src="assets/Responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="assets/Responsive/2.2.9/js/responsive.bootstrap.min.js"></script>
    <script src="assets/js/global.js"></script>

    <script>
	$(document).ready(function() {
		var table = $('#task_tab').DataTable( {
//			responsive: 	true,
			dom: 			'rtp',	// B-utton,f-ind,p-r-ocess,t-able,l-ength,i-nfo,p-agination
/*			scrollY:        "500px",
			scrollX:        true,
			scrollCollapse: true,
			sPaginationType: 'full_numbers',
			processing: true,
			info:		true,
			paging:		false,
			ordering:	true,
			searching:	true,
			pageLength:	10,
			order: 		[ 0, 'asc' ],
			select: 	true,
*/			paging:         false,
			fixedColumns:   {  heightMatch: 'none' }
		} );
		new $.fn.dataTable.FixedHeader( table );
		table.columns.adjust().draw();
	});
    </script>
<!--- <style>	.table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th { padding:0; } </style>	-->
    <style>
		table { max-width: 98vw; margin: 0 1vw; }
		table.table.table-striped.table-bordered td,
		table.table.table-striped.table-bordered th {
			white-space: nowrap; overflow: hidden; text-overflow: ellipsis; max-width: 10vw; padding:0; }
    </style>
</head>
 
<body class="d-flex flex-column w-100">
<?PHP	
// ------------------------------- Page header ----------------------------- -->
?>
<header>
    <nav class="navbar navbar-light navbar-expand-md bg-white pt-1 pb-1">
		<div class="container-fluid">
            <a class="navbar-brand logo"  target="_blank" href="$spe_link">
                <img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width: 300px"></a>
            <h2><?=TASK?> Management</h2>
			<nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
                <div class="container">
					<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
						<span class="sr-only">Toggle navigation</span>
						<span class="navbar-toggler-icon"></span>
					</button>
                    <div class="collapse navbar-collapse" id="navcol-1">
                        <span class="navbar-text actions"> 
<!--							<button class='btn bg-warning' onClick='task_activate()' ><= ADMIN ?></button>	-->
							<button class="btn btn-primary btn-w100 admin" onClick="location.href = 'admin.php' "><?= ADMIN ?></button>
							<button class="btn btn-primary btn-w100 guest" onClick="location.href = 'product.php' "><?= PRODUCT ?></button>
							<button class="btn btn-warning btn-w100 guest" onClick="location.href = 'home.php' ">Home</button>
						</span>
					</div>
                </div>
            </nav>
		</div>
	</nav>
</header>
<?PHP	
// ---------------------------------- taskModal ---------------------------- -->
?>
<div class="modal fade" id="taskModal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content bg-secondary">
            <div class="modal-body">

            </div>
			<div class="text-center" >
				<div class="btn-group" role="group">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn bg-primary text-white" onClick='task_modal_save()' > Save </button>
<!--					<button type="button" class="btn bg-danger text-white" onClick='task_modal_delete()' > Delete </button>	-->
				</div>
			</div>
        </div>
    </div>
</div>
<?PHP	
// ----------------------------------- msgModal ---------------------------- -->

	require_once ("assets/php/message.php");
	if ( !empty($msg) ) { 
?>	<script>
		$('#msgModal').modal("show");
		var newURL = location.href.split("?")[0];
		window.history.pushState('object', document.title, newURL);
		
	</script>
<?PHP }
// ------------------------------ version selector ------------------------- -->
?>
<content>
	<div class='row'>
		<div class="form-check form-check-inline">
			<select id="sel_version" onchange="sel_act_version( $('#sel_version :selected').val() );" >
				<option value="Vx_x" $s>Vx_x</option>
<?PHP			$sql = "SELECT version FROM task_list GROUP BY version";
				$res=$products_db->query($sql) or die(mysql_error($products_db));
				while ($row = $res->fetch_assoc()) {
					$v = $row['version'];
					$s = ($v == "$act_version") ? 'selected' : '';
					echo "<option value=$v $s>$v</option>";
				}   
?>			</select>
		</div>
<?PHP	
// ------------------------------- state selectors ------------------------- -->
?>
		<div class="form-check form-check-inline">
		   <input class="form-check-input" type="radio" name="show_created" id="show_created" value="created" checked="checked" data-waschecked="false">
		   <label class="form-check-label" for="show_created">created</label>
		</div>
		<div class="form-check form-check-inline">
		   <input class="form-check-input" type="radio" name="show_inactive" id="show_inactive" checked="checked" data-waschecked="false">
		   <label class="form-check-label" for="show_active">inactive</label>
		</div>
		<div class="form-check form-check-inline">
		   <input class="form-check-input" type="radio" name="show_active" id="show_active" checked="checked" data-waschecked="false">
		   <label class="form-check-label" for="show_active">active</label>
		</div>
		<div class="form-check form-check-inline">
		   <input class="form-check-input" type="radio" name="show_completed" id="show_completed" checked="checked" data-waschecked="false">
		   <label class="form-check-label" for="show_completed">completed</label>
		</div>
		<div class="form-check form-check-inline">
		   <input class="form-check-input" type="radio" name="show_deleted" id="show_deleted" checked="checked" data-waschecked="true">
		   <label class="form-check-label" for="show_deleted">deleted</label>
		</div>
	</div>
<?PHP	
// --------------------------------- Task Table ---------------------------- -->
?>
	<div class='row'>
	<table id='task_tab' class='table table-responsive table-striped table-bordered nowrap'>
        <thead class='table-dark'>
		<tr>
			<th>ID</th>  
			<th>Vers.</th>  
			<th>Component</th>
			<th style="width:40%">Description</th>
			<th style="width:38%">Solution</th>
			<th>Prio</th>  
			<th>State</th>  
			<th>Creat.</th>
			<th>Owner</th>
			<th>Action</th>  
		</tr>  

        </thead>
        <tbody>
<?php   $sql = "SELECT * FROM `task_list` WHERE `version` LIKE '$act_version' AND `id` > 0 ";
		$res = $products_db->query($sql);  
		while($row=$res->fetch_assoc()) {
?>   	<tr id="tr_<?= $row["id"] ?>" class="h-80 <?= $row['state'] ?>" onDblClick='mark_selected_task(<?= $row["id"] ?>)' >
			<td><button class='btn btn-w80 btn-primary' value="<?= $row["id"] ?>" onClick="copy_to_edit_tab($(this).closest('tr') ) "  
				data-toggle = 'popover' title = 'Edit task' ><?= $row["id"] ?></button></td>
			<td><?= $row['version']		?></td>  
			<td><?= $row['component']   ?></td>  
			<td><?= $row['description'] ?></td>
			<td><?= $row['solution'] ?>	</td>
			<td><?= $row['prio']  ?></td>
			<td><?= $row['state'] ?></td>  
			<td><?= $row['crea']  ?></td>  
			<td><?= $row['own']   ?></td>
<?PHP		if ($row['state'] == 'active' ) { ?>
				<td><button class='btn btn-w80 btn-warning' onClick="task_complete(<?= $row["id"] ?>)" >compl</button></td>
<?PHP		} if ($row['state'] == 'inactive' or $row['state'] == 'created') { ?>
				<td><button class='btn btn-w80 btn-warning' onClick="task_activate(<?= $row["id"] ?>)" >activ</button></td>
<?PHP		} if ($row['state'] == 'completed') { ?>
				<td><button class='btn btn-w80 btn-success' onClick="task_delete(<?= $row["id"] ?>)" >delete</button></td>
<?PHP		}	?>
		</tr>
<?php	} ?>
		</tbody>
	</table>
	</div>
<?PHP	
// ---------------------------------- Edit Table --------------------------- -->

	$sql = "SELECT max(`id`) as `max_task` FROM `task_list`";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	$row=$res->fetch_assoc();
	$next_task = $row["max_task"] + 1;
	$sql = "SELECT `component` FROM `task_list` GROUP BY `component`";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
?>
	<form id='edit_form' name='edit_form' method='POST' >
	<table id='edit_tab' class='table-warning' style='width:100%; white-space: nowrap; '>
		<tr class='text-center'><th >ID</th>  
			<th >Vers.</th>  
			<td class='col-sm-2'>
				<select name='comp_list' id='comp_list' class='col-sm-12' onChange="$('#component')[0].value = this.value;" >
<?php	while ($row = $res->fetch_assoc() ) { $compo = $row["component"] ?>
					<option value="<?= $compo ?>" ><?= $compo ?></option>
<?php	}	?>	</select>
			</td>
			<th>Description</th>
			<th>Solution</th>
			<th>Prio</th>  
			<th>State</th>  
			<th>Creat.</th>
			<th>Owner</th>
		</tr>
		<tr id='edit_row'><td class='col-sm-1'><input type='text' id='id' name='id' 	value="<?= $next_task?>" 	class='col-sm-12' /></td>  
			<td class='col-sm-1'><input type='text' id='version'	name='version'	   	value="<?= $act_version?>" 	class='col-sm-12' /></td>  
			<td class='col-sm-1'><input type='text' id='component'  name='component'   	value='component'	class='col-sm-12' /></td>  
			<td class='col-sm-2'><input type='text' id='description'name='description' 	value='description' class='col-sm-12' /></td>  
			<td class='col-sm-2'><input type='text' id='solution'	name='solution' 	value='solution'  	class='col-sm-12' /></td>  
			<td><select name="prio" id="prio" >
					<option value="low">low</option>
					<option value="normal" selected >normal</option>
					<option value="high">high</option>
				</select>
			</td>  
			<td><select name="state" id="state" >
					<option value="created">created</option>
					<option value="active" selected >active</option>
					<option value="inactive">inactive</option>
					<option value="completed">completed</option>
					<option value="deleted">deleted</option>
				</select>
			</td>
			<td class='col-sm-1'><input type='text' id='crea' 	 	name='crea' 	 value="<?=$_SESSION['usr_id']?>" class='col-sm-12' /></td>  
			<td class='col-sm-1'><input type='text' id='own' 		name='own' 		 value='Owner' 			  		  class='col-sm-12' /></td> 

			<td><button class='btn btn-w80 btn-primary' title='Update or add a task' onClick='task_save();' >save</button></td>
		</tr>
 	</table>  
	</form>
</content>
    
<?php require_once ("assets/php/footer_small.php"); ?>

<script>
    var lang  = "<?=$_SESSION["lang"]?>";
    var right = "<?=$_SESSION["rights"]?>";
    var tr_seld = '';

	function sel_act_version(act_version) {	// *** change the actual version ***
		document.location.href = "task.php?version="+act_version;
	}
    function task_save() {				// *********************** save task ***
		var id = $('#id')[0].value;
		var confText = (lang =='_de')	? "Aufgabe "+id+" speichern?" : "Really save task "+id+" ?";
		var r = confirm(confText);
		if (r == true) { 
			$('#edit_form')[0].action = "task.php?save="+id;
			$('#edit_form')[0].submit();
		}
	}								
    function task_modal_save() {		// ***************** save task modal ***
		var confText = (lang =='_de')	? "Aufgabe speichern?" : "Really save task ?";
		var r = confirm(confText);
		if (r == true) { 
			$('#task_modal')[0].action = "task.php?save=0";
			$('#task_modal')[0].submit();
		}
	}								
    function task_activate(id) {		// ******************* activate task ***
		var confText = (lang =='_de')	? "Aufgabe "+id+" aktivieren?" : "Activate task "+id+" ?";
		var r = confirm(confText);
		if (r == true) { document.location.href = "task.php?activate="+id; }
	}								
    function task_complete(id) {		// ******************* complete task ***
		var confText = (lang =='_de')	? "Aufgabe "+id+" beenden?" : "Really complete task "+id+" ?";
		var r = confirm(confText);
		if (r == true) { document.location.href = "task.php?complete="+id; }
	}								
    function task_delete(id) {			// ********************* delete task ***
		var confText = (lang =='_de')	? "Aufgabe "+id+" löschen?" : "Really delete task "+id+" ?";
		var r = confirm(confText);
		if (r == true) { document.location.href = "task.php?delete="+id; }
	}
	function copy_to_edit_tab(tr) {		// * copy selected vote to edit line ***

		var tbl 	= $('#edit_tab')[0];
		var colVal = Array();
		tr.find('td').each( function(i, e) {
			colVal[i] = $(this).text();
//console.log( i+"--  "+colVal[i].trim() );
		});

//		var tdCells = Array();
		$('#edit_row').children('td').each(function(i, v) {
			if ( $(this).children('input').val() ) {
				$(this).children('input').val(colVal[i]);
//console.log( i+" input: "+tdCells[i] );
				return;
			}; 
			if ( $(this).children('select').val() ) {
				$(this).children('select').val(colVal[i]);
//console.log( i+" select: "+tdCells[i] );
				return;
			}
			if ( $(this).children('button').val() ) {
//				tdCells[i] = "button tag: "
//console.log( i+" button: "+tdCells[i] );
				return;
			} 
//			tdCells[i] = "invalid tag: "
//			console.log( i+" other: "+tdCells[i] );
		});
	}
	function taskEditModal(id) { 	  	// ------------------- edit modal on ---
		$('.editModal-body').load('assets/php/task_edit_modal.php?iid='+id, function() { 
			$('#editModal').modal({show:true}); 
		});
	}
	function mark_selected_task(id) { 	// -------------- mark_selected_task ---
		$('.modal-body').load('assets/php/task_modal_content.php?id='+id, function() { 
			$('#taskModal').modal({show:true}); 
		});
	}

</script>

<script src="assets/js/display.js"></script>

</body>

</html>
