<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/*
 * ****************************** global.php ************************************
 *
 * Copyright 2022 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * *****************************************************************************
 * 
 * Configuration Globals and Common functions
 * 
 * 
 * *****************************************************************************
echo("<pre>"); print_r($adm); echo("</pre>");
 */
$web_base = "/var/www/smartSPE";
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require_once "/var/www/pwds.php";
require "$web_base/assets/PHPMailer/src/Exception.php";
require "$web_base/assets/PHPMailer/src/PHPMailer.php";
require "$web_base/assets/PHPMailer/src/SMTP.php";

{   							// *************************** Configuration ***
{   							// ------------------- Configuration Globals ---
	$backup_fldr = "backup";
    $upload_fldr = "upload";
    $base_fldr = "/var/www/smartSPE";
    $host 	= (isset($_SERVER["HTTP_HOST"])) ? $_SERVER["HTTP_HOST"] : 'nb-hp';
	$indx_url = "https://$host/index.php";
	$ajax_url = "https://$host/ajax.php";
}
{								// ---------------------- database constants ---
/*
 *  now in "/var/www/pwds.php"
 * 
	$host_params["nb-hp"] =		array("srv"=>"localhost", "usr"=>"hans", "pwd"=>"P23RfB5U");
	$host_params["qoscom.de"] = array("srv"=>"localhost", "usr"=>"hans", "pwd"=>"As4-R7u+=3"); 
	$host_params["spe.nb-hp"] =	array("srv"=>"product.single-pair-ethernet.com", "usr"=>"hans", "pwd"=>"MySQL&Warrior");
//	echo "{$host_params["nb-hp"]["srv"]}<br>";
*/	
	switch ($host) {
		case "nb-hp":
		case "spe.localhost":
		case "spe.nb-hp":
			$host = "nb-hp";
//			$host_db = $host_params["nb-hp"];
			$host_db = $host_params["product.single-pair-ethernet.com"];
/*	localhost spe
			define('DB_SERVER',     'product.single-pair-ethernet.com');
			define('DB_USERNAME',   'hans');
			define('DB_PASSWORD',   'MySQL&Warrior');
			break;
	localhost hans
			define('DB_SERVER',   	'localhost');       // local mysql
			define('DB_USERNAME', 	'hans');
			define('DB_PASSWORD', 	'P23RfB5U');
			break;
/*	localhost root
			define('DB_SERVER',   	'qoscom.de');       // hans@qoscom
			define('DB_USERNAME', 	'hans');
			define('DB_PASSWORD', 	'As4-R7u+=3');
//			define('DB_PASSWORD',   'Y-3l&abX');
*/
			break;
		case 'spe.qoscom.de':							// spe,qoscom.de
		case 'qoscom.de':
			$host_db = $host_params["qoscom.de"];
/*			define('DB_SERVER',   	'qoscom.de');       // hans@qoscom
			define('DB_USERNAME', 	'hans');
//			define('DB_PASSWORD', 	'As4-R7u+=3');
			define('DB_PASSWORD',	'Y-3l&abX');
			break;
*/
		case 'single.qoscom.de':						// single,qoscom.de
		case 'product.single-pair-ethernet.com':		// single-pair-ethernet.com
			$host_db = $host_params["product.single-pair-ethernet.com"];
/*			define('DB_SERVER',     'product.single-pair-ethernet.com');
			define('DB_USERNAME',   'hans');
			define('DB_PASSWORD',   'MySQL&Warrior');
*/
			break;
		default:
			die("global.php: db connect error: undefined host: $host");
	}
	define('DB_PROD', 'smartSPE');
	define('DB_ADDR', 'stv_addr_db');
}
{                               // ---------------------- database functions ---
	$products_db = new mysqli($host_db["srv"], $host_db["usr"], $host_db["pwd"], DB_PROD);
	if ($products_db->connect_error) { 
		die("products_db connection failed: " . $products_db->connect_error); 
	}
}
{								// ----------------------- logging constants ---
	define ('ERR', 1);
	define ('WRN', 2);
	define ('MSG', 4);
	define ('DEB', 8);
//	$log_state = DEB+MSG+WRN+ERR;
	$log_state = MSG+WRN+ERR;
								// -------------------------- mail constants ---
	define ('MAIL_HOST', "smtp.udag.de");
	define ('MAIL_USER', "qoscomde-0001");
	define ('MAIL_PASSWORD', "C-{1xCHKgRF4");			// old P2BB^Udiy40x
}
{   							// -------------------- db dependent globals ---
								// -------- mast be after database functions ...
	$now = date('Y-m-d H:i');
	$usr_id = (isset($_SESSION['usr_id'])) ? $_SESSION['usr_id'] : 'na';
	
	$sql = "SELECT `version` FROM `task_list` WHERE `id` = 0";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	$row=$res->fetch_assoc();
	$act_version = $row["version"];

	$sql = "SELECT `vote` FROM `potm` WHERE `id` = 0";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	$row=$res->fetch_assoc();
	$act_vote = $row["vote"];
								// ------------- init database admin address ---
	$res  = $products_db->query("SELECT email FROM accounts WHERE id = 1 OR id = 2 ")
				or die(mysqli_error($products_db));
	$row  = $res->fetch_assoc();
	$sup  = $products_db->query("SELECT * FROM supplier WHERE Email = '{$row["email"]}' ")
				or die(mysqli_error($products_db));
	$adm  = $sup->fetch_assoc();// e.g. $spe_email = $adm["Email"]								
	$adm_sign = "{$adm["Expert"]}<br>{$adm["Company"]}<br><a href='mailto:{$adm["Email"]}' >{$adm["Email"]}</a><br><a href='{$adm["Web"]}' >{$adm["Web"]}</a>";
								// ----------- init database manager address ---
	$row = $res->fetch_assoc();
	$sup  = $products_db->query("SELECT * FROM supplier WHERE Email = '{$row["email"]}' ")
				or die(mysqli_error($products_db));
	$man  = $sup->fetch_assoc();// e.g. $spe_man_email 	= $man["Email"];
	$man_sign = "{$man["Expert"]}<br>{$man["Company"]}<br><a href='mailto:{$man["Email"]}' >{$man["Email"]}</a><br><a href='{$man["Web"]}' >{$man["Web"]}</a>";
								// ------------------------ no reply address ---
	$spe_noreply_mail = "noreply@single-pair-ethernet.com";
}
{                               // -------------------- internationalisation ---
								// ------ mast be after db depemdent globals ---
	$langs = array('_de','_en');
	if (empty($_SESSION["lang"])) { $_SESSION["lang"] = '_de'; }
	if (!empty($_GET["lang"]) and in_array($_GET["lang"], $langs )) {
			$_SESSION["lang"] = $_GET["lang"]; }
	if ($_SESSION["lang"]=="_de") {
		require_once("index_de.php");
		require_once("help_de.php");
	}
	if ($_SESSION["lang"]=="_en") {
		require_once("index_en.php");
		require_once("help_en.php");
	}
	$lang = $_SESSION["lang"];
}
}
{                               // ************************** file functions ***
								// ---------------- delete upload and backup ---
function del_folder($back_upload_fldr, $not_arr, $nur_arr) {
	global $products_db;
	$file_cnt 	= 0;
	$error_cnt	= 0;
	$msg		= '';
	
    if (is_dir($back_upload_fldr)) { 
        $folders = scandir($back_upload_fldr);
		foreach ($folders as $folder) {
			if ($folder == "." or $folder == ".." or in_array($folder, $not_arr) ) continue;
			if ( empty($nur_arr) ) continue;
			if ( is_dir("$back_upload_fldr/$folder") && in_array($folder, $nur_arr) ) {
				write_log("DEB", "global.del_folder - directory $back_upload_fldr/$folder ");
				$files = scandir("$back_upload_fldr/$folder");
				foreach ($files as $file) {
					if ($file == "." or $file == ".." or is_dir("$back_upload_fldr/$folder/$file") ) continue;
					if (unlink("$back_upload_fldr/$folder/$file") ) { 
						$file_cnt += 1; 
					} else {
						$msg = write_log("WRN", "global - del_folder: can not remove $back_upload_fldr/$folder/$file");
						$error_cnt += 1;
					}
				}
				$sql = "DELETE FROM product WHERE `a6_supp` = '$folder' LIMIT 200";
				write_log("DEB", "global - del_folder: $sql");
				if (!$products_db->query($sql) ) {
					$msg = write_log("WRN", "clear - DB delete error: $sql" );
					$error_cnt += 1;
				}
				if (!rmdir("$back_upload_fldr/$folder") ) {
					$msg = write_log("WRN", "global - del_folder: remove folder $back_upload_fldr/$folder error ");
					$error_cnt += 1;
				}
				$msg = write_log("MSG","global.del_folder - $file_cnt files deletes in $back_upload_fldr/$folder, no of errors: $error_cnt");
			} 
		}
	} else $msg = write_log("WRN", "global - del_folder: $back_upload_fldr error");
	return $msg;
}
								
function del_supplier($typ,$list) {		//- delete supplier except $not/$nur ---
	global $products_db, $backup_fldr, $upload_fldr;
	$not = '';
	$nur = '';
	$msg = '';
	$not_def = ",Common,Database,Supplier";
	
	switch ($typ) {
		case 'not': $not = $list.$not_def; break;
		case 'nur': $nur = $list; break;
		default: $msg = write_log("DEB","global.del_supplier - invalid typ $typ");
			return $msg;
			break;
	}
	write_log("DEB","global.del_supplier - delete not: '$not' and delete only: '$nur' ");
	$not_arr = explode(' ',$not);
	$nur_arr = explode(' ',$nur);
	
	$msg = del_folder($backup_fldr, $not_arr, $nur_arr);
	$msg = del_folder($upload_fldr, $not_arr, $nur_arr);

//	$msg = write_log("DEB", "global.del_supplier - $file deleted and ".mysqli_affected_rows($products_db)." deleted from smartSPE");
    return $msg;
}
{/* function rrm_all($dir, $top) {		// ------ remove all files from $top ---
    if (is_dir($dir)) { 
        $files = scandir($dir);
        
		foreach ($files as $file) { 
			if ($file != "." && $file != "..") {
				if (is_dir("$dir/$file") && !is_link("$dir/$file")) {
					rrm_all("$dir/$file", $top);
				} else { 
					unlink("$dir/$file"); 
				}
			} 
		} 
        if ($dir != $top) rmdir($dir);
    } 
}
function rrm_not($dir, $not, $top) {	// ---- remove all files except $not ---
    if (is_dir($dir)) { 
        $files = scandir($dir);
        
		foreach ($files as $file) { 
			if ($file != "." && $file != "..") {
				if (is_dir("$dir/$file") && !is_link("$dir/$file")) {
					if (strpos($not,$file) === false) rrm_not("$dir/$file", $not, $top);
				} else { unlink("$dir/$file"); }
			} 
		} 
        if ($dir != $top) rmdir($dir);
    } 
}
function rrm_sup($dir, $sup, $top) {	// -------- remove only $sup folders ---

    if (is_dir($dir)) { 
        $files = scandir($dir);
        
		foreach ($files as $file) { 
			if ($file != "." && $file != "..") {
				if (is_dir("$dir/$file") && !is_link("$dir/$file")) {
					if (strpos($sup,$file) !== false)  {
						rrm_sup("$dir/$file", $sup, $top);
					}
				} else { unlink("$dir/$file"); }
			} 
		} 
        if ($dir != $top) rmdir($dir);
    } 
}
*/}
function rcopy($src, $dst) { 			// ------- recursive copy src to dst ---

write_log("DEB","global.rcopy - from: $src to $dst"); 
console_log("<<<<< ");  
    $dir = opendir($src); 
	@mkdir($dst); 
  
    while( $file = readdir($dir) ) { 
        if (( $file != '.' ) && ( $file != '..' )) { 
            if ( is_dir($src . '/' . $file) ) { 
                rcopy($src . '/' . $file, $dst . '/' . $file); 
            } else { 
                copy($src . '/' . $file, $dst . '/' . $file); 
            } 
        } 
    } 
    closedir($dir);
}
function do_zip($source, $destination, $include_dir = true) {

    if (!extension_loaded('zip') || !file_exists($source)) { return false; }
    if (file_exists($destination)) { unlink ($destination); }

    $zip = new ZipArchive();
    if (!$zip->open($destination, ZIPARCHIVE::CREATE)) { return false; }
    $source = str_replace('\\', '/', realpath($source));
    if (is_dir($source) === true) {
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);
        if ($include_dir) {
            $arr = explode("/",$source);
            $maindir = $arr[count($arr)- 1];
            $source = "";
            for ($i=0; $i < count($arr) - 1; $i++) { $source .= '/' . $arr[$i]; }
            $source = substr($source, 1);
            $zip->addEmptyDir($maindir);
        }
        foreach ($files as $file) {
            $file = str_replace('\\', '/', $file);
            // Ignore "." and ".." folders
            if( in_array(substr($file, strrpos($file, '/')+1), array('.', '..')) ) continue;
            $file = realpath($file);

            if ($file == "php_error.log") continue;
            if ($file == "register_req.txt") continue;

			if (is_dir($file) === true) {
				$zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
			} else if (is_file($file) === true) {
				try {
	$rep_str = str_replace($source . '/', '', $file);
print("$file, $source, $rep_str ");
					$zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file) );
print(" nacher<br>");
				} catch (Throwable $e){
print("<br><br>$file: ".$e->getMessage()."<br>");
					$msg = write_log("WRN","admin - file '$file' not saved.",
										   "admin - Datei '$file' nicht gesichert" );
die("<br>456");
				}
			}
        }
    }
    else if (is_file($source) === true) {
        $zip->addFromString(basename($source), file_get_contents($source)); }
    return $zip->close();
}
}
{                               // ************************ import functions ***
function recreate($src,$dst){           // ------- create system from backup ---
    if (is_dir($src)) { 
        if (!is_dir($dst)) mkdir($dst);
        $dirs = scandir($src);
        foreach ($dirs as $dir) { 
            if ($dir == "." or $dir == "..") continue;
            if (is_dir("$src/$dir") && !is_link("$src/$dir")) {
                if (!is_dir("$dst/$dir")) mkdir("$dst/$dir");
//echo "create upload folder $dst/$dir<br>";
                import_from("$src/$dir");
                
                $files = scandir("$src/$dir");
                foreach ($files as $file) { 
                    if ($file == "." or $file == "..") continue;
//echo "copy $src/$dir/$file to $dst/$dir/$file<br>";
                    copy( "$src/$dir/$file", "$dst/$dir/$file" );
                } 
            }
        } 
    }
}
function upload($foldername) {          // ------- upload into backup folder ---
    global $backup_fldr, $upload_fldr;
    $msg = '';
//write_log("DEB","global.upload - upload into $foldername"); 
    if (!is_dir($backup_fldr)) mkdir($backup_fldr);
    if (!is_dir($upload_fldr)) mkdir($upload_fldr);
    $backup_folder = "$backup_fldr/$foldername";
    $upload_folder = "$upload_fldr/$foldername";
    if(!is_dir($backup_folder)) mkdir($backup_folder);
    if(!is_dir($upload_folder)) mkdir($upload_folder);
    $file_no = 0;
//write_log("DEB","global.upload - upload_folder: $upload_folder, backup_folder: $backup_folder"); 
    foreach($_FILES['files']['name'] as $i => $name) {
//write_log("DEB","global.upload - uploaded file $i. $name"); 
        if(strlen($_FILES['files']['name'][$i]) > 1) {
            move_uploaded_file($_FILES['files']['tmp_name'][$i],$upload_folder."/".$name);
//write_log("DEB","global.upload - copy: $upload_folder/$name, $backup_folder");
			if (!copy("$upload_folder/$name", "$backup_folder/$name")) {
				write_log("ERR","copy $upload_folder/$name to $backup_folder error");
			}
            $file_no++;
        } 
    }
    write_log("MSG","$file_no files downloaded.", "$file_no Dateien geladen."); 
    return $upload_folder;
}
function import_from($dir) {            // -- import xls und png from backup ---
    global $upld_fldr;
    if ($dh = opendir($dir)){
        while (($file = readdir($dh)) !== false){
            if ($file == "." or $file == "..") continue;
            $path_file  = "$dir/$file";
            $path_parts = pathinfo($path_file);
            $ext = $path_parts['extension'];
            switch ($ext) {
            case "xls";
            case "xlsx";
                // $csv = xlsx_to_csv($dir.$file);
                // csv_to_mysql($csv);
                write_log("WRN", "import - excel not yet implemented"); 
                break;
            case "csv":
                write_log("MSG", "import - from folder $path_file, $dir");
                $msg = ($dir == 'upload/Supplier') ? supplier_to_db($path_file) : csv_to_mysql($path_file);
				if (substr($msg,0,3) == "ERR") return $msg;
                break;
            case "png":
            case "jpg":
            case "jpeg":
            case "gif":
                break;
            default:
                $msg = "import - invalid filetype";
                write_log("ERR", $msg); 
            } // end switch
        }   // end while
        closedir($dh);
        $msg = "import - all files from '$dir' imported.";
        return write_log("MSG", $msg);
    }
    $msg = "import - no such folder '$dir'.";
    return write_log("ERR", $msg);
}
function xlsx_to_csv($xls_file) {      	// -------- convert xlsx file to csv ---
//    echo "xlsx_to_csv($xlsx_file)<br>";
/*
//$xls_file = "Example.xlsx";

    $reader = new Xlsx();
    $spreadsheet = $reader->load($xls_file);

    $loadedSheetNames = $spreadsheet->getSheetNames();

    $writer = new Csv($spreadsheet);

    foreach($loadedSheetNames as $sheetIndex => $loadedSheetName) {
        $writer->setSheetIndex($sheetIndex);
        $writer->save($loadedSheetName.'.csv');
    }
*/
}
function csv_to_mysql($csv_file) {      // --- insert csv file into database ---
    global $products_db, $now, $usr_id;
    
    $sep    = ';';                                  // csv seperator
    $mrl    = 10000;                                // max csv record length
	$rec_no = 0; $err_no = 0; $upd_no = 0; $ins_no = 0;
    
    $sql = "REPLACE INTO product (`id`,`a1_img`,`a2_cat_de`,`a2_cat_en`,`a3_typ_de`,`a3_typ_en`,`a4_pn`,".
        "`a5_pr_de`,`a5_pr_en`,`a6_supp`,`a7_ref_de`,`a7_ref_en`,`a8_prot`,".
        "`b1`,`b2`,`b3`,`b4`,`b5`,`b6`,`b7`,`b8`,`b9`,`ba`,`upd_id`,`updated`,`crd_id`,`created`,`state`) ".
        "VALUES (0,'upload/Common/SPE_logo_blue.png','Katalog','catalog','Typ','type','Part No','Produkt Name','product name',".
        "'Manufacturer','Produkt Link','product link',".
        "'10BASE-T1S,10BASE-T1L,100BASE-T1,1000BASE-T1,2.5GBASE-T1,5GBASE-T1,10GBASE-T1, PoDL',".
        "'b1','b2','b3','b4','b5','b6','b7','b8','b9','ba','$usr_id','$now','$usr_id','$now','active')";

    if (! $products_db->query($sql)) {              // create template record
        $msg = "importCSV - replace error, template record error: ".mysqli_error($products_db)."\n $sql";
        write_log("ERR", $msg);
        return "ERR $msg";
    }
//console_log("--------------------- $csv_file");
    if (!$fp=fopen($csv_file,"r")) {                // open csv file
        $msg = "importCSV - file '$csv_file' open error";
        write_log("ERR", $msg);
        return "ERR $msg";
    }
    while ( ($row = fgetcsv($fp, $mrl, $sep)) !== FALSE) {	// loop thru csv file, $row is current record
        $rec_no++;
		if (!empty($row[6]) ) {
//console_log("rec_no: $rec_no, cat_en: {$row[3]}, pno: {$row[6]}, supp: {$row[9]}");
//write_log("DEB","1. importCSV - img: {$row[1]}, cat_de: {$row[2]}, , cat_en: {$row[3]}, pno: {$row[6]}, supp: {$row[9]}");
		}
                // --------------- check if category and part_no are available and category is correct
        $cat = $row[3];
        if (! ($cat > "") ) continue;						// check if $row[3]] a2_cat_en is not empty
        $pno = $row[6];
        if (! ($pno > "") ) continue;						// check if $row[6] a6_pn is not empty
        $sql = "SELECT cat_en FROM category WHERE cat_en = '$cat'";
        if (!$res = $products_db->query($sql)) {
            $msg = "importCSV - DB error ".mysqli_error($products_db)."\n $sql";
            write_log("ERR $msg");
        }
                //  --------------- update product, if category and part_no exist
        if (!mysqli_num_rows($res)) continue;		
                                                            // check if $row[3] is in category.cat_en     
        $category = 'a2_cat_en'; $part_no = 'a4_pn';
        $sql = "SELECT * FROM `product` WHERE `$category` = '$cat' AND `$part_no` = '$pno' ";
        $res = $products_db->query($sql) or die(mysqli_error($products_db));
                                                            // get columns from database
        $sql = "SHOW COLUMNS FROM product";				
        $flds= $products_db->query($sql) or die("get columns: $sql");
        $fld_no = mysqli_num_rows($flds);
        
        if (mysqli_num_rows($res)) {						// update product
            $flds->fetch_assoc();							// don't update product id
            $sql  =	"UPDATE product SET ";					// loop thru all columns
            for ($i = 1; $fld = $flds->fetch_assoc() and $i < $fld_no - 5; $i++) {
                $sql .= "`{$fld["Field"]}` = '{$row[$i]}',";// build update sql statement
            }												// append update user id and time
            $sql .= "`state`='{$row[$fld_no - 1]}', `upd_id`='$usr_id', `updated`='$now' ";
                                                            // append the where clause
            $sql .= "WHERE `$category` = '$cat' AND `$part_no` = '$pno' LIMIT 1";
            write_log("DEB","importCSV - $cat:$pno updated, $sql");
            $upd_no++;
        } else {											// insert new product,
            $sql = "SELECT MAX(id) as max_id FROM product";	// 	if category and part_no does'nt exist
            $res = $products_db->query($sql);
            $max = $res->fetch_assoc(); 					// find the next id in product table
            $nxt_id = $max["max_id"] + 1;
            $ins  = "INSERT into product (";				// create field list
            for ($i = 0; $fld = $flds->fetch_assoc() and $i < $fld_no - 5; $i++) {
                $ins .= "`{$fld["Field"]}`,";
            }	
            mysqli_data_seek($flds, 1) ;
            $val  = "values ($nxt_id,";						// create value list
            for ($i = 1; $fld = $flds->fetch_assoc() and $i < $fld_no - 5; $i++) {
                $val .= "'{$row[$i]}',";
            }
            $ins .= "`upd_id`,`updated`,`crd_id`,`created`,`state`) "; // add user and times
            $val .= "'$usr_id','$now','$usr_id','$now','{$row[$fld_no-1]}') ";
            $sql = $ins . $val;								// combine field and value list
//            write_log("DEB","importCSV - $cat: $pno inserted, $sql");
            $ins_no++;
        }
        if (!$res = $products_db->query($sql)) {			// execute query
            $msg = write_log("ERR", "importCSV - DB error ".mysqli_error($products_db)."\n $sql");
            return $msg;
        }
		write_log("DEB","importCSV --------- $sql");
    }
    $msg = write_log("MSG","importCSV - $ins_no products inserted and $upd_no updated");
    return $msg;
}
function supplier_to_db($csv_file) { 	// --- insert csv file into database ---
    global $products_db;
    
    $sep    = ';';                                  // csv seperator
    $mrl    = 1000;                                 // max csv record length
	$rec_no = 0; $err_no = 0; $upd_no = 0; $ins_no = 0;

    if (!$fp=fopen($csv_file,"r")) {                // open csv file
        $msg = "importCSV - file '$csv_file' open error";
        write_log("ERR", $msg);
        return "ERR $msg";
    }
    while (($row = fgetcsv($fp, $mrl, $sep)) !== FALSE) {	// loop thru csv file, $row is current record
        $rec_no++;
//if (!empty($row[6]) )
        $supp = $row[1];
        $state = $row[6];
		write_log("DEB","importCSV - supplier: $supp, status: $state");
                // --------------- check if category and part_no are available and category is correct
        if (! ($supp > "") ) continue;						// check if Supplier is not empty
        if (! ($state > "") ) continue;						// check if Status is not empty
															// check if Supplier is already in the table
        $sql = "SELECT * FROM `supplier` WHERE `Supp_id` = '$supp' ";
        $res = $products_db->query($sql) or die(mysqli_error($products_db));
                                                            // get columns from database
        $sql = "SHOW COLUMNS FROM supplier";				
        $flds= $products_db->query($sql) or die("get columns: $sql");
        $fld_no = mysqli_num_rows($flds);
        
        if (mysqli_num_rows($res)) {						// update supplier
            $flds->fetch_assoc();							// don't update supplier id
            $sql  =	"UPDATE supplier SET ";					// loop thru all columns
            for ($i = 1; $fld = $flds->fetch_assoc() and $i < $fld_no; $i++) {
                $sql .= "`{$fld["Field"]}` = '{$row[$i]}',";// build update sql statement
            }	
			$sql = substr($sql,0,(strlen($sql)-1))." WHERE `Supp_id` = '$supp' LIMIT 1";
//			$sql .= "WHERE `Supplier` = '$supp' LIMIT 1";
            write_log("DEB","supplier_to_db - update: $sql");
            $upd_no++;
        } else {											// insert new product,
            $sql = "SELECT MAX(id) as max_id FROM supplier";// if category and part_no does'nt exist
            $res = $products_db->query($sql);
            $max = $res->fetch_assoc(); 					// find the next id in product table
            $nxt_id = $max["max_id"] + 1;
            $ins  = "INSERT into supplier (";				// create field list
            for ($i = 0; $fld = $flds->fetch_assoc() and $i < $fld_no; $i++) {
                $ins .= "`{$fld["Field"]}`,";
            }
            $ins = substr($ins,0,(strlen($ins)-1)).") ";
            mysqli_data_seek($flds, 1) ;
            $val  = "values ($nxt_id,";						// create value list
            for ($i = 1; $fld = $flds->fetch_assoc() and $i < $fld_no; $i++) {
                $val .= "'{$row[$i]}',";
            }
            $val = substr($val,0,(strlen($val)-1)).")";
            $sql = $ins . $val;								// combine field and value list
            write_log("DEB","supplier_to_db - insert: $sql");
            $ins_no++;
        }
        if (!$res = $products_db->query($sql)) {			// execute query
            $msg = write_log("ERR", "importCSV - ".mysqli_error($products_db) );
            return $msg;
        }
    }
    $msg = write_log("MSG","importCSV - $ins_no supplier inserted and $upd_no updated");
    return $msg;
}
}        
{                               // ********************** prepared functions ***
{									// ------------------- prepared template ---
/*$sql = "UPDATE users SET active=1 WHERE email=?";
prep_query($products_db, $sql,[$email]) or die(mysqli_error($products_db));
....
$res = prepared_query($products_db, $sql, ['Sam','Bob','Joe']);
if (mysqli_num_rows($res) > 0 ) {
echo "Affected rows: $res->affected_rows\n";
echo "Last insert id: $products_db->insert_id\n";
*/
/*
$sql = "SELECT * FROM tmp_mysqli_helper_test WHERE id > ?";
$res = prep_select($products_db, $sql, [1]);
while ($row = $res->fetch_assoc())
----
$user_list = prep_select($products_db, $sql, [$start, $limit])->fetch_all(MYSQLI_ASSOC);
*/

}
function prep_query($mysqli, $sql, $params, $types = "") {
	try {
		$pl = count($params);
		$types = $types ?: str_repeat("s", count($params));
//echo "$pl. $types: $sql<br>";
//print_r($params); echo "<br><br>";
		$stmt = $mysqli->prepare($sql);
		$stmt->bind_param($types, ...$params);
		$stmt->execute();
	} catch (Exception $e) {
		print $e->getMessage();
	}
    return $stmt;
}
function prep_select($mysqli, $sql, $params = [], $types = "") {
    return prep_query($mysqli, $sql, $params, $types)->get_result();
}
function update_task($id) {			// ------------------------- update task ---
    global $products_db, $now;
//echo("<pre>"); print_r($_POST); echo("</pre>");

	$sql  = "UPDATE task_list SET version=?, component=?, description=?, solution=?, prio=?, state=?, crea=?, own=?, created=?, completed=? WHERE id=?";
	write_log("DEB","task update - $sql");
	$stmt = $products_db->prepare($sql);
	$stmt ->bind_param('ssssssssssi', $version, $component, $description, $solution, $prio, $state, $crea, $own, $now, $completed, $id );
	foreach ($_POST as $key => $val) {
		$val  = (empty($val) ) ? NULL : $val;
		$$key = $val;
	}
	write_log("DEB","update_task - $sql<br>$version, $component, $description, $solution, $prio, $state, $crea, $own, $now, $completed, $id");
	if ( !$stmt->execute() ) $msg = write_log("ERR",$stmt->error);
	else $msg = write_log("MSG","task update - Task no $id successfully updated.","Aufgabe Nr. $id erfolgreich geändert.");
    return $msg;
}
Function create_task($id) {			// ------------------------- create task ---
    global $products_db, $now;
//echo("<pre>"); print_r($_POST); echo("</pre>");
	
	$sql = "INSERT INTO task_list (`id`,`version`,`component`,`description`,`solution`,`prio`,`state`,`crea`,`own`,`created`) VALUES (?,?,?,?,?,?,?,?,?,?)";
	$stmt = $products_db->prepare($sql);
	$stmt ->bind_param('isssssssss', $id, $version, $component, $description, $solution, $prio, $state, $crea, $own, $now);
	foreach ($_POST as $key => $val) {
		$val = (empty($val) ) ? NULL : $val;
		$$key = $val;
	}
	write_log("DEB","create_task - $sql<b>$id, $version, $component, $description, $solution, $prio, $state, $crea, $own, $now");
	if ( !$stmt->execute() ) $msg = write_log("ERR",$stmt->error);
	else $msg = write_log("MSG","task create - Task no $id successfully created.","Aufgabe Nr. $id erfolgreich erstellt.");
    return $msg;
}
Function create_or_update_task() {	// -------------- create_or_update_ task ---
    global $products_db;
    
    if ( !isset($_POST["id"])) {
		$msg = write_log("ERR","task upd/create - no POST['id'] Parmeter");
		return $msg;
	}
	$id = $_POST["id"];
	if ( !$res = $products_db->query("SELECT * FROM `task_list` WHERE `id` = $id ") ) {
		write_log("DEB", "potm edit - $sql - ".mysqli_error($products_db));
		$msg = write_log("ERR","potm edit - PotM $val could not be saved.","PotM $val konnte nicht gespeichert werden");
		return $msg;				
	}
	if (mysqli_num_rows($res) == 1) {
		$msg = update_task($id); 
	} else {
		$msg = create_task($id);
	}
	return $msg;
}
Function update_user() {			// ------------------------- update user ---
	global $products_db, $usr_id;
	
	$sql  = "UPDATE accounts SET user=?, usr_id=?,avatar=?,email=?,company=?,password=?,start_page=?,rights=?,state=?,v_potm=?,v_state=?,v_no=?,pend_hash=? WHERE id=?";
	$stmt = $products_db->prepare($sql);
	$stmt ->bind_param('sssssssssssi', $user, $usr_id, $avatar, $email, $company,$password,$start_page,$rights,$state, $v_potm, $v_state, $v_no, $pend_hash, $id );
	foreach ($_POST as $key => $val) {
		$val  = (empty($val) ) ? NULL : $val;
		$$key = $val;
	}
	if ( !$stmt->execute() ) $msg = write_log("ERR",$stmt->error);
	else $msg = write_log("MSG","user update - user no $id successfully updated.","Benutzer Nr. $id erfolgreich geändert.");
    return $msg;
}
Function replace_user($id) {		// ------------------------ replace user ---
    global $products_db, $usr_id;
	
	$sql  = "REPLACE INTO accounts (`id`,`user`,`usr_id`,`avatar`,`email`,`company`,`password`,`start_page`,`rights`,`state`,".
			"`v_potm`,`v_state`,`v_no`,`pend_hash`,`up_id`,`updated`,`cr_id`,`created`,`current_session`,`online`) ".
			"VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	$stmt = $products_db->prepare($sql);
	$stmt ->bind_param('isssssssssssssssssss', $id, $user, $usr_id, $avatar, $email, $company, $password, $start_page,$rights,$state,
						$v_potm,$v_state,$v_no,$pend_hash,$up_id,$updated,$cr_id,$created,$current_session,$online );
	foreach ($_POST as $key => $val) {
		$val = (empty($val) ) ? NULL : $val;
		$$key = $val;
	}
//echo "$sql<br>";
//echo("$id, $version, $component, $description, $prio, $state, $crea, $own, $created<br>");
//die("create");
	if ( !$stmt->execute() ) $msg = write_log("ERR",$stmt->error);
	else $msg = write_log("MSG","user replace - user no $id successfully replaces.","Benutzer Nr. $id erfolgreich ersetzt.");
//die("$msg");
    return $msg;
}
Function replace_short() {			// ----------------------- replace short ---
    global $products_db, $usr_id;
	
	$sql  = "REPLACE INTO accounts (`id`,`user`,`usr_id`,`avatar`,`email`,`company`,`password`,`start_page`,`rights`,`state`) ".
			"VALUES (?,?,?,?,?,?,?,?,?,?)";
	$stmt = $products_db->prepare($sql) or die($products_db->error);
	$stmt ->bind_param('isssssssss', $id, $user, $usr_id, $avatar, $email, $company, $password, $start_page,$rights,$state );
	$i = 0;
	foreach ($_POST as $key => $val) {
		$val = (empty($val) ) ? NULL : $val;
		$$key = $val;
		if ($i > 9) break;
		$i++;
	}
//echo "$sql<br>";
//echo("$id, $version, $component, $description, $prio, $state, $crea, $own, $created<br>");
//die("create");
	if ( !$stmt->execute() ) $msg = write_log("ERR",$stmt->error);
	else $msg = write_log("MSG","user replace - user no $id successfully replaces.","Benutzer Nr. $id erfolgreich ersetzt.");
//die("$msg");
    return $msg;
}
}
{                               // ********************** language functions ***
								// ------- translate tables for categy names ---
{ $sql = "SELECT id,cat_en,cat_de,descr_en,descr_de FROM category";
$res = $products_db->query($sql);  
while ($row = $res->fetch_assoc()) {
	$cen[$row["id"]] = [$row["id"],$row["cat_en"],$row["descr_en"]];
	$cde[$row["id"]] = [$row["id"],$row["cat_de"],$row["descr_de"]];
	$icen[$row["cat_en"]] = $row["id"];
	$icde[$row["cat_de"]] = $row["id"];
}
//echo("<pre>"); print_r($cen); echo("</pre>");
//echo("<pre>"); print_r($cde); echo("</pre>");
//echo("<pre>"); print_r($icen); echo("</pre>");
//echo("<pre>"); print_r($icde); echo("</pre>");
}
								// ------ translate tables for product names ---
{ $sql = "SELECT cat,col_id,col_de,col_en,nam_de,nam_en,type,descr_de,descr_en FROM product_col";
$res = $products_db->query($sql);  
while ($row = $res->fetch_assoc()) {
	if ($row["cat"] == "*" or $row["cat"] == "control") {
		$aen[$row["col_id"]] = [$row["col_en"],$row["nam_en"],$row["descr_en"]];
		$ade[$row["col_id"]] = [$row["col_de"],$row["nam_de"],$row["descr_de"]];
		$iaen[$row["col_en"]] = $row["col_id"];
		$iade[$row["col_de"]] = $row["col_id"];
	} else {
		$ben [$row["cat"]][$row["col_id"]] = [$row["col_id"],$row["nam_en"],$row["descr_en"]];
		$bde [$row["cat"]][$row["col_id"]] = [$row["col_id"],$row["nam_en"],$row["descr_de"]];
		$iben[$row["cat"]][$row["col_en"]] = $row["col_id"];
		$ibde[$row["cat"]][$row["col_de"]] = $row["col_id"];
	}
}
//echo("<pre>"); print_r($aen); echo("</pre>");
//echo("<pre>"); print_r($ade); echo("</pre>");
//echo("<pre>"); print_r($iaen); echo("</pre>");
//echo("<pre>"); print_r($iade); echo("</pre>");

//echo("<pre>"); print_r($ben); echo("</pre>");
//echo("<pre>"); print_r($bde); echo("</pre>");
//echo("<pre>"); print_r($iben); echo("</pre>");
//echo("<pre>"); print_r($ibde); echo("</pre>");
}

function c2col($c) {			// -------- category; id to name (and descr) ---
	global $cen,$cde;
	$cat = ($_SESSION["lang"] == "_de") ? $cde[$c][0] : $cen[$c][0];
	return $cat;
}
function c2nam($c) {
	global $cen,$cde;
	$nam = ($_SESSION["lang"] == "_de") ? $cde[$c][1] : $cen[$c][1];
	return $nam;
}
function c2dsc($c) {
	global $cen,$cde;
	$desc = ($_SESSION["lang"] == "_de") ? $cde[$c][2] : $cen[$c][2];
	return $desc;
}
function c2idx($c) {
	global $icen,$icde;
//	$idx = ($_SESSION["lang"] == "_de") ? $icde[$c] : $icen[$c];
	if ($_SESSION["lang"] == "_de") { 
		$idx = (isset($icde[$c])) ? $icde[$c] : "c1_conn";
	} else {
		$idx = (isset($icen[$c])) ? $icen[$c] : "c1_conn";
	}
//echo "$c, $idx<br>";
	return $idx;
}
function a2col($c) {			// ------------------- a product; id to name ---
	global $aen,$ade;
	$col = ($_SESSION["lang"] == "_de") ? $ade[$c][0] : $aen[$c][0];
	return $col;
}
function a2nam($c) {
	global $aen,$ade;
	$nam = ($_SESSION["lang"] == "_de") ? $ade[$c][1] : $aen[$c][1];
return $nam;
}
function a2dsc($c) {
	global $aen,$ade;
	$descr = ($_SESSION["lang"] == "_de") ? $ade[$c][2] : $aen[$c][2];
	return $descr;
}
function b2col($cat,$c) {		// --------- b product parameter; id to name ---
	global $ben,$bde;
//echo "$cat, $c, {$_SESSION["lang"]}<br>";
	$col = ($_SESSION["lang"] == "_de") ? $bde[$cat][$c][0] : $ben[$cat][$c][0];
	return $col;
}
function b2nam($cat,$c) {
	global $ben,$bde;
//	if ($cat == 'c0_all') $cat = 'c1_conn');
	$nam = ($_SESSION["lang"] == "_de") ? $bde[$cat][$c][1] : $ben[$cat][$c][1];
	return $nam;
}
function dsc($cat,$c) {
	global $ben,$bde;
	$descr = ($_SESSION["lang"] == "_de") ? $bde[$cat][$c][2] : $ben[$cat][$c][2];
	return $descr;
}
}
{                               // ********************************* Logging ***
function write_log($prio, $msg, $msg_ge = NULL) {   //  write message to log ---
	global $log_state, $now, $usr_id, $base_fldr;
	$prio = (isset($prio)) ? $prio : 'ERR';
	
	if (constant($prio) & $log_state) {
		$fn = "$base_fldr/data/php-error.log";
//echo 'console.log("fn: $fn")';
//console_log("fn: $fn");echo("<br>");
//		if (!file_exists($fn)) return "ERR: no log file: $fn";
		if (!$fp = fopen($fn, 'a')) return "ERR: file $fn open error";
			 
		$msg = (isset($_SESSION["lang"]) and $_SESSION["lang"] == "_de" and (!empty($msg_ge))) ? $msg_ge : $msg;
		$rec = "$now - $usr_id > $prio: $msg\n";
		$n = fwrite($fp, $rec);
		fclose($fp);
//echo "- $n - $prio: $msg<br>";
		return "$prio: $msg";
	} else return "$prio: invalid priority";
}
function log_and_ret($prio,$to,$msg,$msg_ge=NULL) { // ------ log and return ---
	$msg = write_log($prio,"$msg", "$msg_ge");
die($msg);
	if (!empty($to)) {
		switch ($to) {
			case 'admin': header("Location: admin.php?msg=$msg"); exit(); break;
			case 'home': header("Location: home.php?msg=$msg"); exit(); break;
			case 'product': header("Location: product.php?msg=$msg"); exit(); break;
			case 'task': header("Location: task.php?msg=$msg"); exit(); break;
			default: break;
		}
	}
}
function print_r2($val) { 		// ---------------------- pretty print array ---
	echo '<pre>'; print_r($val); echo  '</pre>'; 
}
function console_log ( $msg ) {	// -------------------------- log to console ---
	$msg = str_replace('"', "''", $msg);
	echo "<script>console.log( \"PHP LOG: $msg\" );</script>";
}
}
{                               // *********************************** Email ***
function checkemail($str) {		// --------------------- check email address ---
	return (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $str)) ? FALSE : TRUE;
}

function send_confirm_msg($subject,$body,$from,$to,$reply) { // ------- send ---
	try {
		$mail = new PHPMailer();
		$mail->IsSMTP();				// ----------------------- mail host ---
		$mail->CharSet 		= 'UTF-8';
		$mail->Host			= MAIL_HOST;
		$mail->SMTPDebug	= 0; // to be activated
		$mail->Debugoutput = 'html';
		$mail->Port			= 465;
		$mail->SMTPAuth		= true;
		$mail->AuthType 	= 'LOGIN';
		$mail->SMTPSecure	= "ssl";
		$mail->Username		= MAIL_USER;
		$mail->Password		= MAIL_PASSWORD;
										// -------------- addresses and body ---
		$mail->setFrom($from[0],$from[1]);
		$mail->AddAddress($to[0],$to[1]);
		$mail->addReplyTo($reply[0],$reply[1]);
//		$mail->addBCC('my.email.address@appinc.co');
		$mail->isHTML(true);
		$mail->Subject 		= $subject;
		$mail->Body = $body;
//echo("<pre>"); print_r($mail); echo("</pre>");
										// ----------------------- send mail ---
		$mail->Send();

		$prio = "DEB";
		$msg = "email: '$body' from {$from[0]} sent to {$to[0]} send.";
	} catch (Exception $e) {
		$prio = "ERR";
		$msg = "confirmation email could not be sent, mailer error: {$mail->ErrorInfo}";
	}

	write_log($prio,$msg);
	return $prio = "MSG";
}

}
?>
