<?PHP
/*
 * ****************************** index.php ************************************
 *
 * Copyright 2022 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 */
//echo("<pre>"); print_r($_GET); echo("</pre>");
if (session_id() == '') { session_start(); };
require_once ("assets/php/global.php");

	$msg = (isset($_GET['msg'])) ? $_GET['msg'] : '';
	$fct = (isset($_GET['fct'])) ? $_GET['fct'] : '';
	$answer_time = 12 * 3600;	// *** time for answering the register email ***
	$act_email = 0;
	switch ($fct) {
	case "register": {			// *********** user register replay received ***
		if (!isset($_GET["hash"])) { $msg = write_log("WRN",REG_INV); break; }
		$hash = $_GET["hash"];
		if (!isset($_GET["email"])) { $msg = write_log("WRN",REG_INV); break; }
		$email = $_GET["email"];
		$sql = "SELECT * FROM accounts WHERE email=? ";
		$res = prep_select($products_db, $sql, [ $email ]) or die(mysqli_error($products_db));
		if ( $row = $res->fetch_assoc() ) {
			$user = $row["user"];
			if ( $row["pend_hash"] == "$hash" and $row["state"] == 'pend' ) {
				if ( (strtotime($row["created"]) + $answer_time) > time() ) {
									// ------------------ update user account ---
					$sql = "UPDATE accounts SET state='act', pend_hash='' WHERE email=? AND pend_hash=? ";
					prep_query($products_db, $sql, [ $email, $hash ]) or die(mysqli_error($products_db));
					$msg = write_log("MSG", $row["user"].REG_ACK);
									// --------- user account confirmation email ---
					$from = $reply = [$adm["Email"], $adm["Expert"]];
					$to   = [$email, $user];
					$body = FIN_BODY.$user.FIN_BODY1.$man_sign;
					send_confirm_msg(FIN_SUBJ, $body, $from, $to, $reply);
					$msg  = write_log("MSG", "Registration complete $email." );
									// ------------------ admin activation email ---
					$from = $reply = [$adm["Email"], $adm["Expert"]];
					$to   = [$man["Email"], $man["Expert"]];
	//				$link = "<p>$user, {$row["company"]}, {$row["email"]}<br><a href='$indx_url?fct=activate&email=$email&user=$user' >";
	//				$body = ACT_BODY.$man["Expert"].ACT_BODY1.$link.ACT_BODY2.$man_sign;
					$link = "<p>$user, {$row["company"]}, {$row["email"]}</p>";
					$body = ACT_BODY.$man["Expert"].ACT_BODY1a.$link.ACT_BODY2a.$man_sign;
					send_confirm_msg(ACT_SUBJ.$user, $body, $from, $to, $reply);
				} else { 
					$sql = "DELETE FROM accounts WHERE email=? LIMIT 1";
					prep_query($products_db, $sql, [ $email ]) or die(mysqli_error($products_db));
									// --------- user account confirmation email ---
					$from = $reply = [$adm["Email"], $adm["Expert"]];
					$to   = [$email, $user];
					$body = ACT_BODY.$user.",<br>".REG_EXPRD.".<br>".$man_sign;
					send_confirm_msg(FIN_SUBJn, $body, $from, $to, $reply);
					$msg = write_log("WRN",REG_EXPRD); 
				}
			} else  { $msg = write_log("ERR","invalid pending hash"); }
		} else { $msg = write_log("ERR",NO_ACCOUNT); }
		} break;
/*
	case "activate": {			// ********************* finish registration ***
		$email = (isset($_GET["email"])) ? $_GET["email"] : $man["Email"];
		$user  = (isset($_GET["user"]))  ? $_GET["user"] : $man["Expert"];
		$sql = "UPDATE accounts SET state = 'act' WHERE email = ? ";
		prep_query($products_db, $sql, [ $email ]) or die(mysqli_error($products_db));
		$from = $reply = [$adm["Email"], $adm["Expert"]];
		$to   = [$email, $user];
		$body = FIN_BODY.$user.FIN_BODY1.$man_sign;
		send_confirm_msg(FIN_SUBJ, $body, $from, $to, $reply);
		$msg  = write_log("MSG", "Registration complete $email." );
		} break;
*/
	case "renew": {				// ************************** renew password ***
		if (!isset($_GET['hash'])) 	{ $msg = write_log("ERR ".INV_INPUT.$_GET['email']); break; }
		if (!isset($_GET['email'])) { $msg = write_log("ERR ".INV_INPUT.$_GET['email']); break; }
		$hash  = $_GET["hash"];
		$email = $_GET["email"];

		$sql = "SELECT * FROM accounts WHERE email=? AND pend_hash=?  AND state='ren' ";
		$res = prep_select($products_db, $sql, [ $email, $hash ]);
		$row = $res->fetch_assoc();
  		if (!$row)	{ $msg = "ERR ".NO_ACCOUNT.$_GET['email']; break; }
		$sql = "UPDATE accounts SET state='ren', pend_hash='' WHERE email=? ";
		prep_query($products_db, $sql, [ $email ]) or die(mysqli_error($products_db));
		$msg = write_log("MSG", $row["user"].REG_ACK);
  		$act_email = $email;
		} break;
 	case "vote": {				// *********** handler for users vote answer ***
		if (!isset($_GET["hash"])) { $msg = write_log("WRN", 'no vote response hash'); break; }
		if (!isset($_GET["email"])) { $msg = write_log("WRN", 'no voter email on resonse message'); break; }
		$hash = $_GET["hash"];
		$email = $_GET["email"];

		$sql = "SELECT * FROM `accounts` WHERE email=?  AND pend_hash=? ";
		$res = prep_select($products_db, $sql, [ $email, $hash ]);
		if ($row = $res->fetch_assoc() ) {
			if ( strtotime($row["updated"]) + 3600 > time() ) {
				$sql = "UPDATE accounts SET v_state='cnt', pend_hash='' WHERE email=? and `pend_hash`=? ";
				prep_query($products_db, $sql, [$email, $hash] ) or die(mysqli_error($products_db));
				$sql = "UPDATE `potm` SET `counter` = `counter` + 1 WHERE `vote` = ? AND `candidate` = ? LIMIT 1 ";
				prep_query($products_db, $sql, [ $row["v_potm"], $row["v_no"] ]) or die(mysqli_error($products_db));
				$msg = write_log("MSG", $row["user"].VOTE_ACK.": ".VOTE_DSC1.": {$row["v_potm"]}, ".VOTE_DSC.": {$row["v_no"] }.");
			} else {
				$sql = "UPDATE accounts SET v_state='', pend_hash='' WHERE email=? and `pend_hash`=? ";
				prep_query($products_db, $sql, [ $email, $hash ]) or die(mysqli_error($products_db));
				$msg = write_log("WRN",LNK_EXPRD); 
			}
		} else { 
			$msg = write_log("ERR",NO_ACCOUNT.": $email");
		} 
		echo "<script>window.close </script>";
		} break;
  	default: {					// ********************************* default ***
		} break;
	}
?>
<!DOCTYPE html>
<html lang="<?=$lang?>">

<head>
    <title>smartSPE</title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
    
    <link href="assets/css/Navigation-with-Button.css" rel="stylesheet" >
    <link rel="stylesheet" href="assets/bootstrap5/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/shards/css/shards.min.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">
<!--	<link rel="stylesheet" href="assets/css/chat-2.css" >	-->

	<script src="assets/jquery/3.5.1/jquery.min.js"></script>
<!-- script src="assets/bootstrap/js/popper.min.js"></script>	-->
	<script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/global.js"></script>
<!--	<script src="assets/js/chat-2.js"></script>	-->
	<script src="assets/js/user_mngt.js"></script>
    
	<script>
 		var session_lang = "<?= $_SESSION['lang'] ?>";
		var msg_posted 	= "<?= $msg ?>";
		var NO_EMAIL 	= "<?= NO_EMAIL ?>";
		$(document).ready(function(){
//			$('[data-toggle="tooltip"]').tooltip()
			$('#loginBtn').popover({title: "<?=LOGIN?>", content: "<?= HLP_LOGIN ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#registerBtn').popover({title: "<?=REGISTER?>", content: "<?= HLP_REGISTER ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#forgotBtn').popover({title: "<?=FORGOTTEN?>", content: "<?= HLP_FORGOTTEN ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#flagBtn').popover({title: "<?=LANGUAGE?>", content: "<?= HLP_LANGUAGE ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('.my_favorite').popover({title: "<?=SPE_CHAMP?>", content: "<?= HLP_POTM ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('.catBtn').popover({title: "<?=CAT_HDR?>", content: "<?= HLP_CAT ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
		});
	</script>

</head>

<body class="d-flex flex-column min-vh-100">
	
<!-- --------------------------- header section ---------------------------- -->
<style>
.head-img {
	width: 100%;
	height: auto;
	background-image: url(assets/images/backgrounds/header_bg_soft.png);
	background-size: cover;
#	background-size: 100%;
	background-repeat: no-repeat;
#	background-attachment: fixed;
#	background-position: center;
}
.footer-img {
	width: 100%;
	height: auto;
	background-image: url(assets/images/backgrounds/blue_br_small.png);
	background-size: cover;
	background-repeat: no-repeat;
}

@media (min-width: 480px)  { h1 {font-size:1.5rem;} }	/* Small devices (landscape phones, 544px and up) 1rem = 16px*/
@media (min-width: 768px)  { h1 {font-size:2rem;} }		/* Medium devices (tablets, 768px and up) */
@media (min-width: 992px)  { h1 {font-size:2.5rem;}	}	/* Large devices (desktops, 992px and up) */
@media (min-width: 1200px) { h1 {font-size:3rem;} }		/* Extra large devices (large desktops, 1200px and up) */
 
</style>
<header>
    <nav class="navbar navbar-light navbar-expand-md p-2">
		<div class="container-fluid p-0" >
<!--			<div class="bg-image navbar" 
				style="background-image: url('assets/images/backgrounds/header_bg_soft.png'); height: auto; width: 100%"> 	-->
			<div class="bg-image head-img navbar responsive">
				<a class="navbar-brand logo" target="_blank" href="<?= SPE_LINK ?>">
					<img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width:300px" ></a>
				<h1 class="text-brown" ><?=SPE_DB?></h1>
				<nav class="navbar navbar-expand-md">
					<div class="container">
<!--						<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
							<span class="sr-only">Toggle navigation</span>
							<span class="navbar-toggler-icon"></span>
						</button>
						<div class="collapse navbar-collapse" id="navcol-1">	-->
							<ul class="nav navbar-nav mr-auto">
								<li id="flagBtn" class="nav-item"><a class="nav-link" href="#"><img src="assets/icons/signs/<?=FLAG?>" ></a></li>
							</ul>
							<span class="navbar-text actions"> 
								<button id="loginBtn" class="btn-lg btn-primary btn-w100" role="button" >Login</button>
<!--							<button id="chatBtn" class="btn btn-light action-button btn-w100" role="button" >Chat</button>  -->
							</span>
<!--					</div>	-->
					</div>
				</nav>
			</div>
		</div>
	</nav>
</header>
<!-- ----------------------------- modal windows --------------------------- -->
<?PHP 
	require_once ("assets/php/message.php"); 	// ----------- message modal ---
	require_once ("assets/html/login.html"); 	// ------------- login modal ---
	require_once ("assets/html/register.html");	// ---------- register modal ---
	require_once ("assets/html/vote.html");	 	// -------------- vote modal ---
	require_once ("assets/html/chat.html");	 	// -------------- chat modal ---
	if ($act_email) 							// ------------- renew modal ---
		require_once ("assets/php/renew.php"); 
	if ( !empty($msg) ) { 						// ---------- show msg modal ---
?>		<script>
			$('#msgModal').modal("show");
		</script>
<?PHP } ?>
<!-- ------------------------------ main section --------------------------- -->

<!--    <main class="container-fluid flex-fill m-1" style="background: url('assets/images/bg_spe.png') no-repeat; width: 100%-1px; height: auto; background-size: 100%;">	-->
    <main class="container-fluid flex-fill">
        <div class="container-fluit">
<!-- ------------------------------ page content --------------------------- -->
<?PHP
	$sql =  ($_SESSION["lang"] == "_de")
		? "SELECT id, img, cat_de AS cat, descr_de AS descr FROM category WHERE id NOT LIKE 'c0%'"
		: "SELECT id, img, cat_en AS cat, descr_en AS descr FROM category WHERE id NOT LIKE 'c0%'";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	$cat_no = mysqli_num_rows($res);
	$act = " class='active' ";
?>
            <div class="row mt-3 ">
<!-- ----------------------------- category carousel ----------------------- -->
			<div class="col-12 col-md-6 col-lg-3 ">
				<div class="text-center bg-light">
					<h4 class='text-brown'><?=SPE_DB?></h4>
				</div>

				<div id="catCarousel" class="carousel slide "  style="height: 500px;" data-ride="carousel">

													<!----------- Indicators -->
					<ul class="carousel-indicators">
						<li data-target="#catCarousel" data-slide-to="0" <?= $act ?> ></li>
<?PHP $act = "";
	  for ($i = 1; $i <= $cat_no; $i++) { ?>
						<li data-target="#catCarousel" data-slide-to="<?= $i ?>" <?= $act ?> ></li>
<?PHP } $act = " active ";?>
					</ul>
													<!-------- The slideshow -->
					<div class="carousel-inner bg-light" style="height: 100%; display: flex;" >
						
						<div class="carousel-item <?= $act ?>"  >
							<div class="card-header" style="height:100px">
								<h6 class="card-title text-center text-dark"><?= CATEGORY ?></h6>
								<h4 class="card-title text-center text-dark"><?= SPE_DB ?></h4>
							</div>
							<div class="card-body bg-light" style="height:320px">
<!--					<img class="card-img-top img-fluid" src="assets/images/tech/header_spe.png" alt="spe_database" >	-->
<?PHP	while ($row = $res->fetch_assoc()) { $id = $row["id"]; $cat = $row["cat"]; $descr = $row["descr"]; ?>
								<h5><a href="javascript: login('<?=$id?>');" class="text-primary"><?=$cat?></a></h5>
<?PHP	} ?>
							</div>
							<div class="card-footer bg-primary text-center text-white" style="height:80px; width:100%;">
								<a onClick="login('<?=$id?>');"><?= ALL_CAT ?></a>
							</div>
						</div>
<?PHP $act = "";
		$res->data_seek(0);
		while ($row = $res->fetch_assoc()) { $id  = $row["id"];	$img = $row["img"];	$cat = $row["cat"];	$descr = $row["descr"]; ?>
							<div class="carousel-item <?= $act ?>" onClick="login('<?=$id?>');"  >
								<div class="card-header" style="height:100px" >
									<h5 class="card-title text-center text-dark"><?= CATEGORY ?></h5>
									<h4 class="card-title text-center"><?= $cat ?></h4>
								</div>
								<div class="card-body text-center" style="height:320px">
									<img class="card-img-top img-fluid mt-30" src="upload/Common/<?= $img ?>" alt="<?= $cat ?>" 
										style="max-height:150px;max-width:300px;" >
									<p class="card-text" ><?= $descr ?></p>
								</div>
							<div class="card-footer bg-primary text-center text-white" style="width:100%; height:80px">
								<a onClick="login('<?=$id?>');"><?=$cat?></a>
							</div>
						</div>
<?PHP $act = ""; } ?>
					</div>
					<button class="carousel-control-prev" href="#catCarousel" role="button" data-slide="prev">
						<span class="carousel-control-prev-icon" aria-hidden="true"></span>
						<span class="visually-hidden">Previous</span>
					</button>
					<button class="carousel-control-next" href="#catCarousel" role="button" data-slide="next">
						<span class="carousel-control-next-icon" aria-hidden="true"></span>
						<span class="visually-hidden">Next</span>
					</button>
				</div>
				<h6 class="text-center text-dark mt-2"><?=CAT_SUP?></h6>
			</div>
<!-- ----------------------------- Champions Cards ------------------------- -->
			<div class="col-12 col-md-6 col-lg-9 ">
				<div class="bg-light h-10">
					<div class="text-center">
						<h4 class='text-brown'><?= SPE_CHAMP ?> <?= $act_vote ?></h4>
					</div>
				</div>
				<div class='row'>
<?PHP
	$sql = "SELECT vote, a2_cat_en AS a2_cat, a4_pn, a6_supp FROM potm WHERE vote = '$act_vote' and `id` > 0 ORDER BY candidate;";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	for ($c = 1; $candi = $res->fetch_assoc();  $c++ ) {
		$vote = $candi["vote"];
//echo "<pre> $c."; print_r($candi); echo "</pre>";
		$sql = SEL_PROD."WHERE a2_cat_en=? AND a4_pn=? AND a6_supp=?";
		$ptr = prep_select($products_db, $sql, [ $candi["a2_cat"], $candi["a4_pn"], $candi["a6_supp"] ]);
		$prd = $ptr->fetch_assoc();
		
//echo "<pre> $c."; print_r($prd); echo "</pre>";
//	if ($c == 3) die("456");
		
		$sql = "SELECT * FROM `potm` WHERE `vote` = '$vote' AND `candidate` = $c";
		$ptn = $products_db->query($sql) or die(mysqli_error($products_db));
//		$sql = "SELECT * FROM `potm` WHERE `vote` = ? AND `candidate` = ?";
//		$ptn = prep_select($products_db, $sql, [ $vote, $c ]);
		$ptm = $ptn->fetch_assoc();
		
		$cnt = $ptm["counter"];
		
        $_SESSION['state'] 	= 'vote';		// allow ajax request
        $_SESSION['rights']	= 'voter';
?>
				<div class='col-12 col-md-6 col-lg-4'>
					<input type="hidden" id="vote_name" value="<?=$vote ?>" >
					<input type="hidden" id="cand_no" value="<?=$c ?>" >

					<div class="card" style="height: 500px; ">
<?PHP   if ($prd) { ?>
                        <div class="card-body text-center bg-light" style="height:100px">
                            <h4 class="card-title><span id="cat"><?=$prd["a6_supp"]?></h4>
							<h5><span id="pn">PN: <?=$prd["a4_pn"]?></span></h5>
						</div>
						<div class="card-body  bg-light text-center" style="height:250px">
							<img class="card-img-top img-fluid mt-30" src="<?= "upload/{$prd["a6_supp"]}/{$prd["a1_img"]}" ?>" alt="<?=CANDIDATE?> <?=$c ?>" 
								style="max-height:150px;max-width:300px;" >
							<br><b><?=$prd["a5_pr"]?></b>	
							<br><?=$prd["a2_cat"]?>
							<br><a id="ref" href="<?= $prd["a7_ref"] ?>"><?=MORE_PROD?></a>
						</div>
						<div style="height:30px">
							<h6 class="text-center text-dark mt-2"><span><?=$vote ?></span><?=CANDIDATE?><span><?=$c?></span></h6>
						</div>
						<div class="card-footer bg-primary text-center text-white" style="width:100%; height:80px">
                            <button onClick="show_vote('<?=$vote?>',<?=$c?>,'<?=$prd["a4_pn"]?>','<?=$prd["a2_cat"]?>','<?=$prd["a5_pr"]?>','<?=$prd["a6_supp"] ?>');"  
                                class="btn btn-block btn-primary my_favorite"><?=MY_FAVOR?></a>
                        </div>
<?PHP   } else { ?>
                        <div class="card-body">
                            <h6 class="card-title"><span id="cat"><?=CANDIDATE?> ?</span>
                            <br><span id="pn"><?=PRODUCT?> ?</span></h6>
                        </div>
                        <div class="card-footer bg-primary text-center">
                            <button class="btn btn-lg btn-primary"><?=NO_FAVOR?></a>
                        </div>
<?PHP   } ?>
                    </div>
                    <h6 class="text-center text-dark mt-2"><?= HAS_VOTES ?><?=$cnt?></h6>
                </div>
<?PHP } ?>
			</div>
            </div>
		</div>
 	</main>
<!-- ----------------------------- footer  section ------------------------- -->
<?PHP
	require_once ("assets/php/footer{$_SESSION["lang"]}.php"); // footer_de/_en
	require_once ("assets/php/smartspe_why.php"); 	// ----------- why modal ---
	require_once ("assets/php/smartspe_what.php"); 	// ---------- what modal ---
	require_once ("assets/php/smartspe_vers.php");	// ------ versions modal ---
	require_once ("assets/php/smartspe_faq.php");	// ----------- faq modal ---
?>
	<script>
		$(document).ready(function() {
			$('#whyBtn').on( "click", function() { $('#whyModal' ).modal('show'); });	
			$('#whatBtn').on("click", function() { $('#whatModal').modal('show'); });
			$('#versBtn').on("click", function() { $('#versModal').modal('show'); });
			$('#faqBtn').on( "click", function() { $('#faqModal' ).modal('show'); });
		});	
	</script>
   
	<footer class="p-10">
		<div class="container-fluit p-10 border" >
<!--			<div class="bg-image row" 
				style="background-image: url('assets/images/backgrounds/blue_br.png'); margin-left:5px;">	-->
			<div class="bg-image footer-img row border">
				<div class="row text-white" style="margin-top:20px">
				<div class="col-sm-5 text-white">
					<div class="row align-items-center">
						<div class="col-md-4"><a class="navbar-brand logo"  target="_blank" href="<?= SPE_LINK ?>">
							<img class="img-responsive" src="upload/Common/SPE_logo_only_light_blue.png" style="width: 120px"></a>
						</div>
						<div class="col-md-8"><?= SPE_CLUB ?><br><?= SPE_ADDR ?></div>
					</div>
				</div>
				<div class="col-sm-1 text-white"></div>
				<div class="col-sm-3 text-white">
					<ul class="text-white">
						<li><a class="text-white" id = 'whatBtn' href="#" ><?= SPE_WHAT ?></a></li>
						<li><a class="text-white" id = 'whyBtn'  href="#" ><?= SPE_WHY  ?></a></li> 
						<li><a class="text-white" href="<?= SPE_LINK ?>" target="_blank" >Industrial Partner Network</a></li>
						<li><a class="text-white" href="<?= CONTACT_LNK ?>" ><?= CONTACT_US ?></a></li>
					</ul>
				</div>
				<div class="col-sm-3 text-white">
					<ul>
						<li><a class="text-white" id = 'faqBtn' href="#" >FAQ</a></li>
						<li><a class="text-white" href="data/<?= USE_TERMS ?>" target="_blank" ><?= USE_ITEM ?></a></li>
						<li><a class="text-white" href="<?= PRIV_LNK ?>" target="_blank" ><?= PRIVACY ?></a></li>
						<li><a class="text-white" href="<?= IMPR_LNK ?>" target="_blank" >Impressum</a></li>
					</ul>
				</div>
			</div>
			</div>
			<div class="text-center" style="width:100%;">
				Designed by: <a href="mailto://hans.lackner@qoscom.de">Hans Lackner</a>   <a href="https://QoSCom.de/">QoSCom Quality in Communications GmbH</a>
			</div>
		</div>
	</footer>
<script>
	sessionStorage.setItem('index', 0); 
	window.addEventListener('storage',() => {
		alert( sessionStorage.getItem('index') );
		window.location.reload(true);
	});
</script>
		
</body>
</html>

