<?php
ob_implicit_flush(true);
ob_end_flush(); 
/*
 * ****************************** admin.php *************************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 * 	Administraation
 *
 * echo("<pre>"); print_r($_GET);  echo("</pre>");
 * echo("<pre>"); print_r($_POST); echo("</pre>");
 * echo("<pre>"); print_r($_SESSION); echo("</pre>");
 * 
 * *****************************************************************************
 */
require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");
//echo("<pre>"); print_r($_POST); echo("</pre>");

{ $mon21 = array(
	['Jan','2021','2021-01-01','2021-01-31'], ['Feb','2021','2021-02-01','2021-02-28'], ['Mar','2021','2021-03-01','2021-03-31'],
	['Apr','2021','2021-04-01','2021-04-30'], ['Mai','2021','2021-05-01','2021-05-31'],	['Jun','2021','2021-06-01','2021-06-30'],
	['Jul','2021','2021-07-01','2021-07-31'], ['Aug','2021','2021-08-01','2021-08-31'],	['Sep','2021','2021-09-01','2021-09-30'],
	['Okt','2021','2021-10-01','2021-10-31'], ['Nov','2021','2021-11-01','2021-11-30'],	['Dez','2021','2021-12-01','2021-12-31']);
}
{ $mon22 = array(
	['Jan','2022','2022-01-01','2022-01-31'], ['Feb','2022','2022-02-01','2022-02-28'], ['Mar','2022','2022-03-01','2022-03-31'],
	['Apr','2022','2022-04-01','2022-04-30'], ['Mai','2022','2022-05-01','2022-05-31'],	['Jun','2022','2022-06-01','2022-06-30'],
	['Jul','2022','2022-07-01','2022-07-31'], ['Aug','2022','2022-08-01','2022-08-31'],	['Sep','2022','2022-09-01','2022-09-30'],
	['Okt','2022','2022-10-01','2022-10-31'], ['Nov','2022','2022-11-01','2022-11-30'],	['Dez','2022','2022-12-01','2022-12-31']);
}
{ $mon23 = array(
	['Jan','2023','2023-01-01','2023-01-31'], ['Feb','2023','2023-02-01','2023-02-28'], ['Mar','2023','2023-03-01','2023-03-31'],
	['Apr','2023','2023-04-01','2023-04-30'], ['Mai','2023','2023-05-01','2023-05-31'],	['Jun','2023','2023-06-01','2023-06-30'],
	['Jul','2023','2023-07-01','2023-07-31'], ['Aug','2023','2023-08-01','2023-08-31'],	['Sep','2023','2023-09-01','2023-09-30'],
	['Okt','2023','2023-10-01','2023-10-31'], ['Nov','2023','2023-11-01','2023-11-30'],	['Dez','2023','2023-12-01','2023-12-31']);
}
{ $mon24 = array(
	['Jan','2024','2024-01-01','2024-01-31'], ['Feb','2024','2024-02-01','2024-02-29'], ['Mar','2024','2024-03-01','2024-03-31'],
	['Apr','2024','2024-04-01','2024-04-30'], ['Mai','2024','2024-05-01','2024-05-31'],	['Jun','2024','2024-06-01','2024-06-30'],
	['Jul','2024','2024-07-01','2024-07-31'], ['Aug','2024','2024-08-01','2024-08-31'],	['Sep','2024','2024-09-01','2024-09-30'],
	['Okt','2024','2024-10-01','2024-10-31'], ['Nov','2024','2024-11-01','2024-11-30'],	['Dez','2024','2024-12-01','2024-12-31']);
}
{ $mon25 = array(
	['Jan','2025','2025-01-01','2025-01-31'], ['Feb','2025','2025-02-01','2025-02-28'], ['Mar','2025','2025-03-01','2025-03-31'],
	['Apr','2025','2025-04-01','2025-04-30'], ['Mai','2025','2025-05-01','2025-05-31'],	['Jun','2025','2025-06-01','2025-06-30'],
	['Jul','2025','2025-07-01','2025-07-31'], ['Aug','2025','2025-08-01','2025-08-31'],	['Sep','2025','2025-09-01','2025-09-30'],
	['Okt','2025','2025-10-01','2025-10-31'], ['Nov','2025','2025-11-01','2025-11-30'],	['Dez','2025','2025-12-01','2025-12-31']);
}
{ $mon26 = array(
	['Jan','2026','2026-01-01','2026-01-31'], ['Feb','2026','2026-02-01','2026-02-28'], ['Mar','2026','2026-03-01','2026-03-31'],
	['Apr','2026','2026-04-01','2026-04-30'], ['Mai','2026','2026-05-01','2026-05-31'],	['Jun','2026','2026-06-01','2026-06-30'],
	['Jul','2026','2026-07-01','2026-07-31'], ['Aug','2026','2026-08-01','2026-08-31'],	['Sep','2026','2026-09-01','2026-09-30'],
	['Okt','2026','2026-10-01','2026-10-31'], ['Nov','2026','2026-11-01','2026-11-30'],	['Dez','2026','2026-12-01','2026-12-31']);
}
function month_stats($table, $start, $end) {	/* *** statistic on table *** */
	global $products_db;
	$sum = 0;
	$cnt = 0;
	$ret = array();
	$i = 0;
	while($start < $end) {
		$m = substr(date('F',strtotime($start)),0,3);
		$y = date('Y',strtotime($start) );
		$next_m = date('Y-m-d',strtotime($start . "+1 month"));
		$sql = ( $table == 'db_log')
			? "SELECT '$m', '$y', COUNT(id) AS no FROM db_log WHERE t_start >= '$start' AND t_start < '$next_m' "
			: "SELECT '$m', '$y', COUNT(id) AS no FROM $table WHERE created >= '$start' AND created < '$next_m' ";
		$res = $products_db->query($sql) or die(mysqli_error($products_db));
		$row = $res->fetch_array();
		$sum += $row[2];
		$ret[$cnt] = [ $row[0], $row[1], $row[2], $sum ];
		$cnt += 1;
		$start = $next_m;
	}
	return($ret);
}
function user_stats($month) {	/* ******************* statistic on users *** */
	global $products_db;
	
	$sum = 0;
	$cnt = 0;
	$accounts = array();
	foreach ( $month as $mon) {
		$sql = "SELECT '$mon[0]', '$mon[1]', COUNT(id) AS no FROM accounts WHERE created >= '$mon[2]' AND created <= '$mon[3]' AND state = 'act'";
		$res = $products_db->query($sql) or die(mysqli_error($products_db));
		$row = $res->fetch_array();
		$sum += $row[2];
		$accounts[$cnt] = [ $row[0], $row[1], $row[2], $sum ];
		$cnt += 1;
	}
	$sql = "UPDATE year_stat SET users = {$accounts[$cnt-1][3]} WHERE year = {$accounts[$cnt-1][1]}";
	$products_db->query($sql) or die(mysqli_error($products_db));
	return($accounts);
}
function prod_stats($month) {	/* **************** statistic on products *** */
	global $products_db;
	
	$sum = 0;
	$cnt = 0;
	$products = array();
	foreach ( $month as $mon) {
		$sql = "SELECT '$mon[0]', '$mon[1]', COUNT(id) AS no FROM product WHERE created >= '$mon[2]' AND created <= '$mon[3]' AND state = 'Active'";
		$res = $products_db->query($sql) or die(mysqli_error($products_db));
		$row = $res->fetch_array();
		$sum += $row[2];
		$products[$cnt] = [ $row[0], $row[1], $row[2], $sum ];
		$cnt += 1;
	}
	$sql = "UPDATE year_stat SET prods = {$products[$cnt-1][3]} WHERE year = {$products[$cnt-1][1]}";
	$products_db->query($sql) or die(mysqli_error($products_db));
	return($products);
}
function login_stats($month) {	/* ****************** statistic on logins *** */
	global $products_db;
	
	$sum = 0;
	$cnt = 0;
	$logins = array();
	foreach ( $month as $mon) {
		$sql = "SELECT '$mon[0]', '$mon[1]', COUNT(id) AS no FROM db_log WHERE t_start >= '$mon[2]' AND t_start <= '$mon[3]' ";
		$res = $products_db->query($sql) or die(mysqli_error($products_db));
		$row = $res->fetch_array();
		$sum += $row[2];
		$logins[$cnt] = [ $row[0], $row[1], $row[2], $sum ];
		$cnt += 1;
	}
	$sql = "UPDATE year_stat SET logins = {$logins[$cnt-1][3]} WHERE year = {$logins[$cnt-1][1]}";
	$products_db->query($sql) or die(mysqli_error($products_db));
	return($logins);
}
function log_db() {			/* *************** store log info in database *** */
	global $web_base, $products_db;
	
	$log_path  = "$web_base/data";
	$log_files = ["20220527_php-error.log","20221219_php-error.log","20220527_php-error.log"];
	$cnt_sum = 0;
	foreach ($log_files as $log_file) {
		echo("copying $log_file into db_log<br>");

		$logs = fopen("$log_path/$log_file", 'r');
		$cnt = 0;
		while($line = fgets($logs)) {	// 2022-07-14 20:03 - na > MSG: login - Herzlich willkommen Hans Lackner
			if ( strpos($line, "MSG: login") > 0 ) {
				$l   = explode(' - ', $line);
				if (count($l) < 3) {
					echo("<br>invalid record: $line<br>");
					continue; }
										// ------------------- get date/time ---
				$tim = $l[0];
										// -------------------------- get id ---
				$l1  = explode(' > ', $l[1]);
				$uid = $l1[0];
										// ------------------- get user name ---
				$str = $l[2];
				$dex = "Herzlich willkommen ";
				$enx = "Nice to meet you ";
				if (strpos($str, $dex) !== false ) {
					$pos = strpos($str, $dex);
					$user= substr($str, $pos+strlen($dex), strlen($str)-strlen($dex)-1);
				} else
				if (strpos($str, $enx) !== false ) {
					$pos = strpos($str, $enx); $del = $enx;
					$user= substr($str, $pos+strlen($enx), strlen($str)-strlen($enx)-1);
				} else {
					echo("<br>$cnt. no login record: $str<br>");
					$user = '';
				}
										// ---- find users email in accounts ---
				$user = str_replace("'","`",$user);
				$email = '';
				$sql = "SELECT email FROM accounts WHERE user = '$user'";
				$res = $products_db->query($sql);
				if ($res) { 
					if ( $row = $res->fetch_assoc() ) $email = $row['email'];
				}
										// ------- insert record into db_log ---
				$sql = "INSERT INTO `db_log` (`typ`,`uid`,`user`,`email`,`t_start`,`note`) VALUES ('session','$uid','$user','$email','$tim','from $log_file')";
				if (!$products_db->query($sql)) {
					echo("<br>Database error: $sql<br>");
					die("910");
					continue; }
				$cnt += 1;
// echo("$cnt, $tim $email<br>");
				if ($cnt % 1 == 0 ) echo(".");
			}
		}
		echo("$log_file has $cnt logins<br>");
		$cnt_sum += $cnt;
	}
	echo("sum of all logins: $cnt<br>");
}
/* ******************************* select function ************************** */
$msg  = (isset($_GET['msg']))  ? $_GET['msg']  : '';
$stat_type  = (isset($_POST['stat_type']))  ? $_POST['stat_type']  : 'date';

switch ($stat_type) {
	case '2021':	{
		$month = $mon21;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case '2022':	{
		$month = $mon22;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case '2023':	{
		$month = $mon23;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case '2024':	{
		$month = $mon24;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case '2025':	{
		$month = $mon25;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case '2026':	{
		$month = $mon26;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
		break; }
	case 'date':	{
		$start = (isset($_POST["from"]) ? $_POST["from"] : '2021-01-01');
		$end   = (isset($_POST["to"])   ? $_POST["to"]   : '2027-01-01');
		$accounts = month_stats('accounts', $start, $end);
		$products = month_stats('product', $start, $end);
		$logins   = month_stats('db_log', $start, $end);
		break; }
	case 'log_db':	{
		header('Location: admin.php?log_db');
		exit();
		break; }
	default:			{	// ---------- ----- function not implemented ---
		$month = $mon24;
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins   = login_stats($month);
//		$msg = write_log("ERR","admin - not yet implemented",
//							   "admin - nicht implementiert" );
		break; }
}
?>
<!DOCTYPE html>
<html lang="<?=LANG?>">

<head>
    <title>smartSPE Administration</title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
    
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">

    <script src="assets/jquery/3.5.1/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/bootbox/js/4.4.0/bootbox.min.js"></script>
	<script src="assets/js/global.js" type='text/javascript'> </script>

	<script>
        var lang = "<?=$lang?>";
        var right = "<?=$_SESSION["rights"]?>";
        
		$(document).ready(function(){
			$('#importBtn').popover({title: "Import", content: "<?= HLP_IMPORT ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#iclearBtn').popover({title: "<?= CLEAR ?>", content: "<?= HLP_CLEAR ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#statisticBtn').popover({title: "Statistic", content: "<?= HLP_statistic ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
		});

	</script>

</head>

<body class="d-flex flex-column min-vh-100">

<body>
<!-- ----------------------------- Page header ----------------------------- -->
<header>
	<table id="nav_table" class='table nowrap' style='width:100%'>
		<tr class='bg-light'>
			<td class='col-sm-2 bg-light'>
				<a class='navbar-brand logo'  target='_blank' href="<?= SPE_LINK ?>" >
					<img class='img-responsive' src='upload/Common/SPE_logo_black.png' alt='SPE Logo' width='100%'>
				</a>
			</td>
			<td class='bg-light'><h3 style='font-size: 3vw;'>Statistik</h3></td>
			<td class='col-sm-6'> </td>
			<td class='col-sm-4' style='vertical-align: middle; text-align:right;'>
				<button class='btn btn-primary btn-w100 admin' onClick="location.href = 'admin.php' "><?= ADMIN ?></button>
				<button class='btn btn-primary admin' onClick="location.href = 'product.php' ">Product</button>
				<button class='btn btn-warning home'  onClick="location.href = 'home.php'  ">Home</button>
			</td>
		</tr>
		<tr style = "background-imgage: url('assets/images/bg_header.png')">
<!--			<img src = 'assets/images/bg_header.png' class = 'img-responsive' width='100%' alt = 'blue header' ></td>	-->
		</tr>
	</table>
</header>
<?php
	require_once ("assets/php/message.php");
	require_once ("assets/html/clear.html"); 	// ----- clear product modal ---
	if ( !empty($msg) ) { 
?>	<script>
		$('#msgModal').modal("show");
	</script>
<?PHP }	?>
<!-- ------------------------------ Page content --------------------------- -->
<content>
<!--     <main class="page catalog-page">
        <section class="clean-block clean-catalog dark">
			<div class="content">	--->
				<div class="d-flex mr-3 justify-content-end">

						<form name='statisticFrm' action='statistic.php' method='post' enctype='multipart/form-data'> 
<!--						<button class='btn btn-success w-100' >statistic</button>
							<div class="text-center">	-->
								<select name="stat_type" id="stat_type" onchange="document.forms['statisticFrm'].submit();">
									<option value="date">Datum</option>
									<option value="2021">2021</option>
									<option value="2022">2022</option>
									<option value="2023">2023</option>
									<option value="2024" select>2024</option>
									<option value="2025">2024</option>
									<option value=""> </option>
									<option value="log_db">Copy Logins to DB</option>
								</select> 
								<input type="datetime" style="width:90px" name="from" required value="2021-01-01" />
								<input type="datetime" style="width:90px" name="to"   required value="2026-01-01" />
								<button type='submit' class="btn btn-sm btn-warning w-60" >o.k.</button>
<!--							</div>	-->
						</form>
				</div>
				<hr>
					 
                    <div class="row">
                        <div class="col-md-12">
                            <div class="products">
                                <div class="row no-gutters">
                                    <div class="col-12 col-md-6 col-lg-2 super">
                                        <div class="clean-product-item">
			<table style='width:100%;'>
<?PHP	$i = 0;
		foreach ( $accounts as $acc) { ?>
<?PHP		if ($acc[0] == 'Jan' or $i == 0) { ?>
				<th colspan=9>User <?=$acc[1]?></th>
<?PHP		}
			$i++; ?>
				<tr><td><?=$acc[0]?></td><td><?=$acc[1]?></td><td><?=$acc[2]?></td><td><?=$acc[3]?></td></tr>
<?PHP	}	?>
			</table>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
			<table style='width:100%;'>
<?PHP	$i = 0;
		foreach ( $products as $prod) {
			if ($prod[0] == 'Jan' or $i == 0 ) { ?>
			<th colspan=9>Products <?=$prod[1]?></th>
<?PHP		}
			$i++; ?>
				<tr><td><?=$prod[0]?></td><td><?=$prod[1]?></td><td><?=$prod[2]?></td><td><?=$prod[3]?></td></tr>
<?PHP	}	?>
			</table>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
			<table style='width:100%;'>
<?PHP	$i = 0;
		foreach ( $logins as $login) {	
			if ($login[0] == 'Jan' or $i == 0 ) { ?>
			<th colspan=9>Logins <?=$login[1]?></th>
<?PHP		}
			$i++; ?>
				<tr><td><?=$login[0]?></td><td><?=$login[1]?></td><td><?=$login[2]?></td><td><?=$login[3]?></td></tr>
<?PHP	}	?>
			</table>
                                        </div>
                                    </div>
 
								</div>
                            </div>
                        </div>
                        
                    </div>
<!--           </div>
        </section>
    </main>	-->
</content>

<script type="text/javascript">
	var lang  	= "<?=$_SESSION["lang"] ?>";
	var right 	= "<?=$_SESSION["rights"] ?>";
</script>
            <!-- --------------------- Page footer ------------------------- -->
<?php require_once ("assets/php/footer_small.php"); ?>

	<script src="assets/js/display.js"></script>

</body>
</html>
<?PHP
/*
function login_store() {	/* *************** store log info in database *** *
	global $web_base, $products_db;
	
	$log_path  = "$web_base/data";
	$log_files = ["20220527_php-error.log","20221219_php-error.log"];
	foreach ($log_files as $log_file) {
		
		$logs = fopen("$log_path/$log_file", 'r');
		$cnt = 0;
		while($line = fgets($logs)) {
			if ( strpos($line, "MSG: login") > 0 ) {	// 2022-07-14 20:03 - na > MSG: login - Herzlich willkommen Hans Lackner
				$l   = explode(' - ', $line);
				$tim = $l[0];
				$l1  = explode(' > ', $l[1]);
				$id	 = $l1[0];
				$l2	 = explode(' ', $l[2]);
				$l2l = count($l2);
				$nn  = $l2[$l2l-1];
				$vn	 = $l2[$l2l-2];
				$sql = "INSERT INTO `smartSPE`.`logins` (`login`, `uid`, `surname`, `firstname`) VALUES ('$tim', '$id', '$nn', '$vn')";
				if (!$products_db->query($sql)) {	// ------- execute query ---
					$typ = "ERR";
					$msg = ($_SESSION["lang"] == '_de') ? "Fehler beim speichern" : "Login not stored due to database error.";
				}
				$cnt += 1;
			}
		}
		echo("$log_file has $cnt logins<br>");
	}
}
*/
/*
switch ($stat_type) {
	case 'all':	{
		$accounts = user_stats($month);
		$products = prod_stats($month);
		$logins = login_stats($month);
		break;
	}
	case 'users':	{
		$accounts = user_stats($month);
		break;
	}
	case 'products':	{
		$products = prod_stats($month);
		break;
	}
	case 'logins':	{
		$logins = login_stats($month);
		break;
	}
	case 'store':	{
		$logins = login_store();
		break;
	}
	case 'log_db':	{
		header('Location: admin.php?log_db');
		exit();
		break;
	}
	default:			{	// ---------- ----- function not implemented ---
		$msg = write_log("ERR","admin - not yet implemented",
							   "admin - nicht implementiert" );
		break;
	}
}
*/

?>
