<?php
/* 
 * *****************************************************************************
 * DataTables smartSPE server-side processing .
 * *****************************************************************************
 */
require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");
require_once ("assets/php/globals_product.php" );
// $_POST = $_SESSION["post"];
// $_SESSION["post"] = $_POST;
// $_FILES = $_SESSION["files"];
// $_SESSION["files"] = $_FILES;
//echo("<pre>"); print_r($_POST); echo("</pre>");
//die("123");
	$request = (!empty($_POST["request"])) ? $_POST["request"] : 99;
	write_log("DEB","product_ajax - request: $request");
	$imgPath = 'assets/images/products/';
/*
 * ************************** ajax request switch ******************************
 */
switch ($request) {
	case 1:	{				// *************** get data for DataTable, req.1 ***
		write_log("DEB","product_ajax - 1: get data for DataTable");
		$draw = $_POST['draw'];
		$row = $_POST['start'];			//---------------------- Read value ---
		$rowperpage = $_POST['length']; // Rows display per page
		$columnIndex = $_POST['order'][0]['column']; // Col//umn index
		$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
		$extCols = array('a2_cat','a3_typ','a5_pr','a7_ref');
		if (in_array($columnName, $extCols)) $columnName .= $_SESSION["lang"];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		write_log("DEB","product_ajax - request: $request, draw: $draw, start: $row, row/page: $rowperpage");
										// -------------------------- Search ---
		$searchValue = ( isset($_POST['search']['value'])) ?                    // Search value
            mysqli_escape_string($products_db,$_POST['search']['value']) : '';
		$selectValue = ( isset($_POST['select']['value'])) ?                    // Select value
            mysqli_escape_string($products_db,$_POST['select']['value']) : '';
		$productView = ( isset($_POST['view']['value'])) ?                      // Product view
            mysqli_escape_string($products_db,$_POST['view']['value'])   : ''; 
		$searchValue = ($searchValue > '') ? $searchValue : $selectValue;

		$searchQuery = " ";
		if ($searchValue > '') {
/*			serarch value without '%' not working
			$searchQuery = ($lang == '_de')	 
				? " and (a2_cat_de like '$searchValue' or a3_typ_de like '$searchValue' or 
					a4_pn like'$searchValue' or a5_pr_de like'$searchValue' or 
					a6_supp like'$searchValue' or a8_prot like '$searchValue' ) "
*/
			$searchQuery = 
				" and (a2_cat_en like '%$searchValue%' or a3_typ_en like '%$searchValue%' or 
					a4_pn like'%$searchValue%' or a5_pr_en like'%$searchValue%' or 
					a6_supp like'%$searchValue%' or a8_prot like '%$searchValue%' ) ";
		}					// --- Total number of record//s without filtering ---
		$sel = mysqli_query($products_db,"select count(*) as allcount from product");
		$records = mysqli_fetch_assoc($sel);
		$totalRecords = $records['allcount'];
							// ------ Total number of records with filtering ---
		$sel = mysqli_query($products_db,"select count(*) as allcount from $productView WHERE 1 ".$searchQuery);
		$records = mysqli_fetch_assoc($sel);
		$totalRecordwithFilter = $records['allcount'];//
							// ------------------------------- Fetch records ---
		$empQuery = "SELECT * FROM $productView WHERE 1 $searchQuery ORDER BY ".
				"$columnName $columnSortOrder LIMIT $row,$rowperpage";
		($empRecords = $products_db -> query($empQuery)) or die(mysqli_error($products_db));
        write_log("DEB","product_ajax - empQuery: $empQuery");

		$data = array();
		while ($row = mysqli_fetch_assoc($empRecords)) {
			if ($row["id"] == 0) continue;
							// --------------------------------- Make Record ---
			if (!$rcrd = make_record($row, $products_db)) {
				$response = array("error" => "make_record error, see log file.");
				echo json_encode($response);
				exit;
			}
			$recrd = array();
			foreach ($rcrd as $key => $valary) {
                $recrd[$key] = $valary[1];
			}
			array_push($data, $recrd);
		}
							//------------------------------------- Response ---
		$response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordwithFilter,
			"aaData" => $data
		);
		$row_s = json_encode($response);
//write_log("DEB","product_ajax - row: $row_s");
		echo json_encode($response);
		exit; 
		} break;
	case 2:	{				// ****** fetch details for product modal, req.2 ***
		$id = get_id_or_exit();
		write_log("DEB","product_ajax - 2: fetch details for product no $id");
		$sql = "SELECT * FROM product WHERE id = $id";			// $cat = a2col('a2_cat');
		$record = $products_db->query($sql);					//	$response = array(
																//	'id'	=> $row['id'],
		if (mysqli_num_rows($record) > 0) {						//	'a1_img' 	=> $row['a1_img'],
			$row = mysqli_fetch_assoc($record);					//	'a2_cat' 	=> $row['a2_cat_de'],
							//---------------------------------- Make Record ---
			$response = array();
			if (!$response = make_record($row, $products_db)) {
				$response = array("status" => 0,"message" => "make_record error.");
				echo json_encode($response);
				exit;
			}
							//------------------------------------- Response ---
			echo json_encode( array("status" => 1,"data" => $response) );
		} else {
			echo json_encode( array("status" => 0, "message" => "no records found.") );
		}
		exit; 
		} break;
	case 3:	{				// ********** save new or updated product, req.3 ***
		$id = $_POST["id"];
		write_log("DEB","product_ajax - 3: save new or updated product# $id");
		$id = get_id_or_exit();
							// -------------------------------- Save Product ---
		$res = ins_or_upd_product($_POST, $id);
		$sta = (substr($res,0,3) == 'ERR') ? 0 : 1;
		$arr = explode(':',$res);
		write_log($arr[0],$arr[1]);
		echo json_encode( array("status" => $sta, "message" => "$res" ) );
		exit;
		} break;		
	case 4:	{				// *********************** delete product, req.4 ***
									//	TODO delete picture also
		$id = get_id_or_exit();
		write_log("DEB","product_ajax - 4: delete product no $id");
		$res = $products_db -> query("SELECT * FROM product WHERE id=$id");
//		if (mysqli_num_rows($record) > 0) {
		if ($row = mysqli_fetch_assoc($res)) {
			$img = $row["a1_img"];
			$sql = "DELETE FROM product WHERE id=$id LIMIT 1";
			if ($products_db -> query($sql) ) {
				$delPath = $img;
				if (file_exists($delPath)) { 
                    unlink ($delPath); 
                }
				$sta = 1; $msg = ($_SESSION["lang"] == '_de') ? "MSG:Produkt Nr. $id gelöscht" : "MSG:Product no. $id deleted.";
                write_log("MSG","$msg");
			} else {
				$sta = 0; $msg = ($_SESSION["lang"] == '_de') ? "ERR:Datenbank Fehler, Produkt Nr. $id nicht gelöscht" : "ERR:Database error product no. $id not deleted.";
                write_log("ERR","$msg");
			}
		} else {
			$sta = 0; $msg = ($_SESSION["lang"] == '_de') ? "ERR:Produkt Nr. $id nicht gefunden" : "ERR:Product no. $id not found.";
            write_log("ERR","$msg");
		}
		echo json_encode( array("status" => $sta, "message" => $msg ) );
		exit; 
		} break;
	case 5:	{				// ******** get categories for select tag, req 5 ***
		$fld = (isset($_POST['field'])) ? $_POST['field'] : 'inv';
		write_log("DEB","product_ajax - 5: get options for '$fld' single Select");
		
		switch ($fld) {
			case 'a2_cat':
				$sql = ($_SESSION['lang'] == '_de') 
					? "SELECT id, cat_de AS txt FROM category"
					: "SELECT id, cat_en AS txt FROM category";
				break;
/*			case 'a3_typ':
				$sql = ($_SESSION['lang'] == '_de') 
					? "SELECT COUNT(id) AS id, a3_typ_de as txt FROM product GROUP BY a3_typ_de"
					: "SELECT COUNT(id) AS id, a3_typ_en as txt FROM product GROUP BY a3_typ_en";
				break;
			case 'a6_supp':
				$sql = "SELECT id, a6_supp AS txt FROM product GROUP BY a6_supp";
				break; */
			default:
				echo json_encode( array("status" => 0,"message" => "field not defined" ) );
				exit; break;
		}
		$res = $products_db -> query($sql);
		
		$data = array();
		while ($row = mysqli_fetch_array($res)) {
			$data[] = array( "id"=>$row['id'], "text"=>$row['txt'] );
		}
		echo json_encode( array("status" => 1,"data" => $data ) );
		exit; 
		} break;
	case 6:	{				// ***************** import product image, req.6 ***
		$id = get_id_or_exit();	// ****************** get uploads files ***
		write_log("DEB","product_ajax - 6: import image for product no $id");
	
		if (empty($_FILES)) {	die("$_FILES empty");	}
			
		$file = $_FILES['fileName'];
//		$name = $file['name'];
//		$path = $file['tmp_name'];
		if (!$fp=fopen($file['tmp_name'],"r")) { die("{$file['tmp_name']} does not exist"); }

//echo("<pre>"); print_r($_FILES); echo("</pre>");
//echo("<pre>"); print_r($_POST); echo("</pre>");
	
		$target_dir = "$imgPath";
		$target_base = "{$id}_".$file['name'];
		$target_file = $imgPath.$target_base;
		$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
		write_log("DEB","upload - target: $target_file");
									// ************ allow picture files only ***
		$allowedTypes = array('jpg','jpeg','gif','png','TIFF');
		if (!in_array($imageFileType, $allowedTypes)) {
			$sta = 0; $msg = ($_SESSION["lang"] == '_de') 
				? "ERR:Import '$target_file' - falscher Dateityp, es sind nur Bildtypen erlaubt."
				: "ERR:upload '$target_file' - Inv. filetype, only picture types allowed.";
			echo json_encode( array("status" => $sta, "message" => $msg ) );
			exit; break;
		}
									// ****************** copy uploaded file ***
		$msg = "{$file['tmp_name']} to $target_file";
		if (move_uploaded_file($file['tmp_name'], $target_file)) {
			write_log("MSG", "upload - $msg  finished successfully");
		} else { 
			write_log("ERR", "upload - $msg error");
			$sta = 0; $msg = ($_SESSION["lang"] == '_de') 
				? "ERR:copy '$msg' error."
				: "ERR:upload '$target_file' - upload error.";
			echo json_encode( array("status" => $sta, "message" => $msg ) );
			exit; break;
		}
							// ************* enter target file into database ***
		$sql = "UPDATE product SET `a1_img` = '$target_base' WHERE `id` = $id";
		$products_db->query($sql) or die("ERR:mysql error: $sql");

		write_log("MSG", "File $target_file uploaded and appended to product $id");
		$sta = 1; $msg = ($_SESSION["lang"] == '_de') 
			? "MSG:Datei $target_file importiert und Produkt Nr. $id zugeordnet."
			: "MSG:File $target_file uploaded and appended to product no $id.";
		echo json_encode( array("status" => "$sta", "message" => "$msg" ) );
		exit; 
		} break;
	case 7:	{				// * get protocols for select multiple tag req.7 ***
		write_log("DEB","product_ajax - 7: get protocols for multiple select tag");
		$sql = "SELECT id, protocol FROM protocol";
		$res = $products_db -> query($sql);
		
		$data = array();
		while ($row = mysqli_fetch_array($res)) {
			$data[] = array( "id"=>$row['id'], "text"=>$row['protocol'] );
		}
		echo json_encode( array("status" => 1,"data" => $data ) );
		exit; 
		} break;
	case 8:	{				// **************** champion vode handling req.8 ***
		if (!isset($_POST["email"]) ) { 
			$sta = 0; 
			$msg = ($_SESSION["lang"] == '_de') 
				? "ERR:falsche Email Adresse."	: "ERR:Invalid email address.";
			echo json_encode( array("status" => $sta, "message" => $msg ) );
			write_log("ERR","$msg");
			exit();
		}
		$email 	= $_POST["email"];
		$potm 	= $_POST["potm"];  
		$voteNo = $_POST["voteNo"];  
		$votePN = $_POST["votePN"];  
		$voteCat  = $_POST["voteCat"];  
		$voteProd = $_POST["voteProd"];  
		$voteSupp = $_POST["voteSupp"];  

		$sql = "SELECT * FROM accounts WHERE `email` = '$email'";
		($res = $products_db->query($sql)) or die(mysqli_error($products_db));

		$usr_id= 	"CV";
		$now =date("Y-m-d H:i:s");

		if ($res->num_rows == 0) {		// ------------ email doesnot exists ---
			$user =		"SPE Voter";
			$start_page="index.php";
			$acc_state=	"tmp";
			$rights=	"vote";
			$sql = "INSERT INTO accounts (user,email,start_page,state,rights,cr_id,created) VALUES (?,?,?,?,?,?,?)";
			$stmt = $products_db->prepare($sql);
			$stmt->bind_param("sssssss",$user,$email,$start_page,$acc_state,$rights,$usr_id,$now);
			$stmt->execute();
//			$stmt->close();
		} else {
			$row = $res->fetch_assoc();
			$user = $row["user"];
			if ($row["v_potm"] == $potm ) {
				$sta = 1; 
				$msg = ($_SESSION["lang"] == '_de') 
					? "WRN:Sorry, Du hast bereits gewählt, nächsten Monats gibts eine neue Chance."	
					: "WRN:Sorry, you allready voted, next month there is a new chance.";
				echo json_encode( array("status" => $sta, "message" => $msg ) );
				exit; 				
			}
		}
		$v_state='req';
		$up_id='CV';
		$pend_hash = substr(md5(time()), 0, 45);

		$sql = "UPDATE accounts SET pend_hash=?, v_potm=?, v_state=?, v_no=?, up_id=? WHERE email='$email'";
//echo("$sql<br>");
		$stmt= $products_db->prepare($sql);
		$stmt->bind_param("sssis", $pend_hash, $potm, $v_state, $voteNo, $up_id);
		$stmt->execute();
		$stmt->close();
		
//echo("$resp_addr<br>");
		if ($_SESSION["lang"] == '_de') {
			$subject = "Bitte bestätigen Sie Ihre Wahl zum SPE Prosukt des Monats.";
			$body = "<!DOCTYPE html>".
				"<html lang='de-DE'>".
				"<head>".
					"<meta http-equiv='Content-Type' content='text/html'>".
					"<meta charset='utf-8'>".
				"</head>".
				"<body>".
					"<div>".
						"<p>Besten Dank, $user,<br><br>für die Beteiligung an der Auswahl des Produktes des Monats.<br>".
						   "Um Ihre Wahl (des Kandidaten Nr. $voteNo)  abzuschließen, klicken Sie bitte auf den folgenden Link</p>".
						"<p><a href = '$resp_addr?hash=$pend_hash' >Wahl abschließen</a></p>".
						"<p>Viel Spaß an den Ergebnissen<br>".
						   "Matthias Fritsche</p>".
					"</div>".
				"</body>".
				"</html>";
		} else {
			$subject = "Please confirm your vote for the SPU product of the month.";
			$body = "<!DOCTYPE html>".
				"<html lang='en-US'>".
				"<head>".
					"<meta http-equiv='Content-Type' content='text/html'>".
					"<meta charset='utf-8'>".
				"</head>".
				"<body>".
					"<div>".
						"<p>Thanks, $user,<br><br>for the vote on the SPE Product of the month.<br>".
							"To confirm your vote (Candidate No. $voteNo), please click on the following link</p>".
						"<p><a href = '$resp_addr?hash=$pend_hash' >Confirm your vote</a></p>".
						"<p>Be happy wth thr results<br>".
						  " Matthias Fritsche</p>".
					"</div>".
				"</body>".
				"</html>";
		}
		$from	 = ['register@QoSCom.de', 'SPE Voting'];
		$to 	 = [$email, $user];
		$reply	 = ['noreply@QoSCom.de', 'No Reply'];
		if (send_confirm_msg($subject, $body, $from, $to, $reply)) {
			$sta = 1;
			$msg = ($_SESSION["lang"] == '_de') 
				? "MSG:Bestätigungsemail erfolgreich gesendet."	
				: "MSG:Confirmation email successfully sent.";
		} else {
			$sta = 0; 
			$msg = ($_SESSION["lang"] == '_de') 
				? "ERR:Bestätigungsemail konnte nicht gesendet werden."	
				: "ERR:Confirmation email could not be send.";
		}
		echo json_encode( array("status" => $sta, "message" => $msg ) );
		exit; 
		} break;
	case 9:	{				// ****************** vote: vote, cand, prod_id  ***
							// -------------------- check requires parameter ---
		$vote	= $_POST["vote"]; 
		$cand	= $_POST["cand"]; 
		$pid	= $_POST["pid"];
		write_log("DEB","product_ajax - request: 9, vote: $vote, cand: $cand, pid: $pid");
		if (! ($vote and $pid) ) {
			echo json_encode( array("status" => 0, "message" => "parameter missing.") );
			exit;
		}
							// -------------------- product already selected ---
		$rec = $products_db->query("SELECT * FROM `potm` WHERE `vote`='$vote' AND `pid`=$pid ");
		if (mysqli_num_rows($rec) > 0) {
			$msg = write_log("WRN","Product already selected for vote $vote.", "Produkt wurde bereits für Wahl $vote ausgewählt.");
			echo json_encode( array("status" => 0, "message" => "$msg") );
			exit;
		}
							// ------------------------------ candidat empty ---
		$rec = $products_db->query("SELECT * FROM `potm` WHERE `vote`='$vote' AND `candidate`=$cand ");
		if (mysqli_num_rows($rec) > 0) {
			$msg = write_log("WRN","Candidate $cand not empty for vote $vote.", "Kandidat $cand ist nicht frei für Wahl $vote.");
			echo json_encode( array("status" => 0, "message" => "$msg") );
			exit;
		}
							// ----------------get next empty record in potm ---
		$rec = $products_db->query("SELECT max(id) as max_id FROM `potm` ");
		$row = mysqli_fetch_assoc($rec);
		$nxt_id = $row["max_id"] + 1;
		write_log("DEB","product_ajax - request: 9, nxt_id: $nxt_id");
							// ----------------------- get product parameter ---
		$rec = $products_db->query("SELECT * FROM `product` WHERE `id`='$pid' ");
		if (!$row = mysqli_fetch_assoc($rec)) {
			$msg = write_log("WRN","Product no $pid not found.", "Produkt no $pid nicht gefunden.");
			echo json_encode( array("status" => 0, "message" => "$msg") );
			exit;
		}
							// ------------ insert a new Product of th Month --- 
		$sql = "INSERT INTO `potm` (`id`, `vote`, `candidate`, `counter`, `pid`, `a2_cat_en`, `a2_cat_de`, `a4_pn`, `a6_supp`, `state`, `uid`, `update`)  ".
							"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$stmt = $products_db->prepare($sql);
		$stmt ->bind_param('isiissssssss', $nxt_id, $vote, $cand, $counter, $pid, $a2_cat_en, $a2_cat_de, $a4_pn, $a6_supp, $state, $usr_id, $now);
		$counter = 0; $a2_cat_en = $row["a2_cat_en"]; $a2_cat_de = $row["a2_cat_de"]; $a4_pn = $row["a4_pn"];  $a6_supp = $row["a6_supp"]; $state = 'created';
		foreach ($_POST as $key => $val) {
			$val = (empty($val) ) ? NULL : $val;
			$	$key = $val;
		}
		if ( !$stmt->execute() ) {
			write_log("DEB","product_ajax - ".mysqli_error($products_db) );
			$msg = write_log("ERR","Can't insert product no $pid into PotM database.", "Datenbank Fehler: Produkt Nr. $pid nicht eingefügt.");
			echo json_encode( array("status" => 0, "message" => "$msg") );
			exit;
		}
		
		$msg = write_log("MSG","Product no $pid inerted into PotM database.", "Produkt Nr. $pid in die PotM Datenbank eingefügt.");
		echo json_encode( array("status" => 0, "message" => "$msg") );
		exit;
		} break;
	default:{				// * die with invalid request parameter, default ***
		$msg = write_log("product_ajax - default: invalid request parameter: {$_POST["request"]}");
		echo json_encode( array("status" => 0, "message" => $msg ) );
	}
}

function get_id_or_exit() { // ********** check for product id req.param.) ***
	global $products_db;
	
	if (!isset($_POST['id'])) {
		$sta = 0; 
        $msg = ($_SESSION["lang"] == '_de') ? "ERR:Keine Produkt Nr. angegeben"	: "ERR:missing product no.";
		echo json_encode( array("status" => $sta, "message" => $msg ) );
		write_log("ERR","$msg");
		exit;
	}
    $ret = mysqli_escape_string($products_db,$_POST['id']);
	return $ret;
}

