<?php
ob_implicit_flush(true);
//ob_end_flush(); 
///	ini_set("error_log", "/tmp/php-error.log");
/*
 * *************************** maintenance.php *********************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * *****************************************************************************
 * 
 * *****************************************************************************
 * assets/php/restore.php
 * ----------------------
 * is called from restore.php which includes this file.
 * assets/php/restore.php, may be called by other pho files or by crontab.
 * Parameter:
 * 	rst_file=file 		from backup server (qoscom.de) in /var/www/Backups/
 * 		e.g. restore.php?to_restore=221025_SPE_smartSPE.zip
 * 		if restore_file is missing, the latest file in /var/www/Backups is taken
 *  rst_do=action 		function to be executed
 * 		replace				restore website and database
 *		save				as replace but save wabsite and database
 * 		db_table			restore only db_zable 	
 * 
 * *****************************************************************************
echo("<pre>"); print_r($_GET); echo("</pre>");
echo("<pre>"); print_r($allowed_hosts); echo("</pre>");
 */
$web_path  = "/mnt/www";
$web_base  = "{$web_path}/smartSPE";
$rst_file  = (isset($_GET["rst_file"])) ? $_GET["rst_file"] : 'latest';
$rst_do    = (isset($_GET["rst_do"])) ? $_GET["rst_do"] : 'save';
$zip_name  = "$web_base.zip";
//echo("$rst_file, $rst_do <br>");

echo("starting restore<br>");
//goto end;
/* ******************* find backup files on backup server *********************/

echo("$backup_host<br>");
	$conn = ssh2_connect($backup_host, 22);
	if ( !ssh2_auth_password($conn, $backup_user, $backup_pass) ) {
		$msg = write_log("ERR","restore - failed to connect to $backup_host", "restore - Fehler bei der Verbindung zu $backup_host");
		exit(0);
	}
	$sftp = ssh2_sftp($conn);
	$sftp_fd = intval($sftp);
	
	if ( $rst_file == 'latest' ) {
		$latest = "";
		$dirHdl = opendir("ssh2.sftp://$sftp_fd/$backup_path");
		while (false !== ($file = readdir($dirHdl))) {
			if ($file == '.' || $file == '..') continue;
			$latest = ( $file > $latest ) ? $file : $latest;
		}
		$rst_file = $latest;
	}
	if ( $latest == '' ) {
		$msg = write_log("ERR","restore - no backup files found", "restore - keine Backup Dateien gefunden");
		exit(0);
	}
/* *************************** save current system ****************************/

if ( $rst_do == 'save' ) {

	require_once ("assets/php/backup.php");
	
}
/* *************** get the selected website from Backup server ****************/
echo("ssh2_scp_recv($conn, {$backup_path}$rst_file, {$backup_temp}$rst_file <br>");
	if ( !ssh2_scp_recv($conn, "{$backup_path}$rst_file", "{$backup_temp}$rst_file" ) ) {
		$msg = write_log("ERR","restore - failed to copy {$backup_path}$rst_file to {$backup_temp}$rst_file",
							   "restore - Fehler beim kopieren von {$backup_path}$rst_file nach {$backup_temp}$rst_file");
		echo("$msg<br>");
	}
//echo("$rst_file<br>");
/* *********************** unzip backup file to .tmp **************************/
	
	$zip = new ZipArchive;
	if ($zip->open("{$backup_temp}{$rst_file}") === TRUE) {
		$zip->extractTo("{$backup_temp}");
		$zip->close();
		echo 'Unzipped Process Successful<br>';
	} else {
		$msg = write_log("ERR","restore - unzip error on $rst_file. ", "restore - Unzip Fehler bei $rst_file.");
		exit(0);
	}
//end:
/* ***************************** load database ********************************/
	$cmd = "mysql --user={$db_prms['usr']} --password={$db_prms['pwd']} ".DB_PROD."  < {$backup_temp}smartSPE.sql";
echo("$cmd<br>");	
	if ( $res = shell_exec($cmd) !== null ) {
		$msg = write_log("ERR","restore - load ds error: $res", "restore - Fehler beim laden der Datenbank: $res");
		echo("$msg<br>");
		exit(0);
	}
	$msg = write_log("MSG","restore - database loaded", "restore - Datenbasis geladen");
	echo("$msg<br>");
/* ****************************** copy website ********************************/
	$cmd = "mv $web_base {$web_base}.bak";
echo("$cmd<br>");
	if ( $res1 = shell_exec($cmd) !== null ) {
		$msg = write_log("ERR","restore - can not copy $web_base to $web_base.bak",
							   "restore - Fehler beim kopieren $web_base nach {$web_base}.bak");
		echo("$msg<br>");
		exit(0);
	}
//echo ("2. res1: $res1<br>");
	$cmd = "mv {$backup_temp}smartSPE $web_base";
echo("$cmd<br>");
	if ( $res2 = shell_exec($cmd) !== null ) {
		$msg = write_log("ERR","restore - can not copy {$backup_temp}.smartSPE to $web_base",
							   "restore - Fehler beim kopieren von {$backup_temp}.smartSPE nach $web_base");
		echo("$msg<br>");
		exit(0);
	}
	shell_exec("chmod -R 775 $web_base");
	$msg = write_log("MSG","restore - website successfully restored", "restore - Website erfolgreich wiederhergestellt.");
	echo("$msg<br>");


?>
