<?php
/*
 * ****************************** admin.php *************************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 * 	Administraation
 *
 * echo("<pre>"); print_r($_GET);  echo("</pre>");
 * echo("<pre>"); print_r($_POST); echo("</pre>");
 * echo("<pre>"); print_r($_SESSION); echo("</pre>");
 * 
 * *****************************************************************************
echo("<pre>"); print_r($_GET); echo("</pre>");
 */
require_once ("assets/php/session_state.php");
require_once ("assets/php/global.php");

$msg  = (isset($_GET['msg']))  ? $_GET['msg']  : '';

if (isset($_GET)) {
	foreach ( $_GET as $key => $val ) {
		switch ($key) {
        case 'backup_db':	{	//-backup DB, zip website and send to server ---

require_once ("backup.php");
/*			
			$sql_file = 'backup/Database/smartSPE.sql';
			$cmd = "mysqldump --host='nb-hp' --user='hans' --password='P23RfB5U' smartSPE > $sql_file";
			shell_exec($cmd);
			if (file_exists($sql_file) && filesize($sql_file) > 1000) {
				$msg = write_log('MSG',"admin backup_db - smartSPE DB dumped to $sql_file",
									   "admin backup_db - smartSPE DB gesichert nach $sql_file" );
				shell_exec("chmod 775 $sql_file");
			} else {
				$msg = write_log('ERR','admin backup_db - smartSPE DB dump error',
									   'admin backup_db - smartSPE DB Dump Fehler' );
				break;
			}
			
			$dat = date('ymd');
			$to_be_zipped = '/var/www/smartSPE/';
			$zip_file = "/var/www/{$dat}_smartSPE.zip";
			$cmd = "zip -r -q $zip_file $to_be_zipped";
			$res = shell_exec($cmd);
			if (file_exists($zip_file) && filesize($zip_file) > 1000) {
				$msg = write_log('MSG',"admin backup_db - smartSPE website zipped to $zip_file",
									   "admin backup_db - smartSPE Website zipped nach $zip_file" );
				shell_exec("chmod 775 $zip_file");
			} else {
				$msg = write_log('ERR','admin backup_db - zip smartSPE failed',
									   'admin backup_db - Zip smartSPE Fehler' );
				break;
			}

			$dst_host = "hans@nb-hp";
			$dst_path = "/var/www/Backups";
			$dst_file = "{$dst_host}:{$dst_path}";
			try {
				$cmd = "scp $zip_file $dst_file";
				$res = shell_exec($cmd);
				shell_exec("chmod 775 $zip_file");
				$msg = write_log('MSG',"admin backup_db - DB and website saved in $dst_file",
									   "admin backup_db - DB und Website gesichert in $dst_file" );
			} catch (Exception $e) {
				$msg = write_log("ERR","admin - faild to copy $zip_file to $dst_file: ".$e->getMessage(),
									   "admin - Fehler beim sichern von $zip_file nach $dst_file: ".$e->getMessage());
				break;
			}
/*
			$zip = new ZipArchive();
			$ret = $zip->open($zip_file, ZipArchive::CREATE | ZipArchive::OVERWRITE);


/*
			$dat = date("ymd");
			$backup_db_fldr = "$backup_fldr/Database";
			if (!file_exists($backup_db_fldr)) { mkdir("$backup_db_fldr", 0775); }
			$tbl = ($val == 'all') ? '' : ".$val";
			$dump_srv = (isset($_GET["server_db"])) ? $_GET["server_db"] : $host;
//			$backup_file = "$backup_db_fldr/{$dat}_{$dump_srv}_smartSPE{$tbl}_$act_version.sql";
			$backup_file = "$backup_db_fldr/smartSPEsql";
			$dump_db = $host_params[$dump_srv];
			$tbl = ($val == 'all') ? '' : "$val";
			$cmd = "mysqldump --host {$dump_db["srv"]} --user {$dump_db["usr"]} --password='{$dump_db["pwd"]}' smartSPE $tbl > $backup_file";
			write_log("DEB","$cmd");
			exec($cmd." 2>&1", $result, $err);
			if ($err) {
				$msg = write_log("ERR","admin backup_db - smartSPE database error, err=$err",
									   "admin backup_db - smartSPE Datenbank Fehler, err=$err" );
				break 2;
			}
			exec("chmod 775 $backup_file");
								   
			$src_fldr = "/var/www/smartSPE";
			$zip_file = "/var/www/{$dat}_smartSPE.zip";
			do_zip($src_fldr, $zip_file);

//			$dst_src ="hans@nb-hp";
			$dst_path = "/home/hans/";
//			$dst_file = "$dst_src:$dst_path";
			
			try {
				$conn = ssh2_connect( "nb-hp", 22 );
				ssh2_auth_password( $conn ); 	//, 'hans', '3jX4-9sD' );
				ssh2_scp_send( $conn );			//, $zip_file, $dst_path, 0644 );
/*
//print("scp $zip_file $dst_file<br>");
				$res = shell_exec( "scp $zip_file $dst_file" );
print("scp result: $res<br>");
*
				$msg = write_log("MSG","admin - smartSPE database stored to $backup_file and smartSPE are copied to $dst_file",
									   "admin - smartSPE Databasis gespeichert in '$backup_file' und smartSPE kopiert nach $dst_file");
			} catch (Exception $e) {
				$msg = write_log("ERR","admin - faild to copy $dst_file to $rem_url: ".$e->getMessage(),
									   "admin - Fehler beim sichern von smartSPE: ".$e->getMessage());
			}
*/
// die("<br>123");
            break;
		}
        case "server_db":	{	// -------------------------------- not used ---
			break;
}
        case "restore_db":	{	// -------------------restore website and DB ---
			$backup_file = "$backup_fldr/Database/$val";
			$cmd = "mysql --user={$host_db["usr"]} --password='{$host_db["pwd"]}' smartSPE < $backup_file";
			write_log("DEB","$cmd");
			exec($cmd." 2>&1", $result, $err);
//var_dump($result);
			if ($err) {
				$msg = write_log("ERR","admin restore_db - database restore error loading from '$backup_file'<br>err=$err: $result[0]",
									   "admin restore_db - Databasis restore Fehler beim Laden von '$backup_file'<br>err=$err: $result[0]" );
				break 2;
			}
            $msg = write_log("MSG","admin - smartSPE database loaded from $backup_file",
								   "admin - smartSPE Datenbasis geladen von '$backup_file'");
            break;
		}
        case "clear":		{	// ----- delete all entries in product table ---
			$type = $_GET["type"];
			$list = $_GET["list"];
			$msg = del_supplier($type, $list);
            break;
		}
        case "import":		{	// --------------------- import product data --- 
            if(!(isset($_POST['upload']) and $_POST['foldername'] > "") ) {
                $msg = write_log("ERR","Backup folder name missing", "Backup Verzeichnisname fehlt.");
                break;
            }
            $upload_fldr= $_POST['upload'];
            $foldername = $_POST['foldername'];
            if ($foldername == "recreate") {
                recreate($backup_fldr, $upload_fldr);
            } else {
//console_log("foldername: $foldername, upload_fldr: $upload_fldr");
                $upld_fldr = upload($foldername);
//                $upld_fldr = upload($upload_fldr);
                $msg = import_from($upld_fldr);
            }
            break;
        }
		default:			{	// ---------- ----- function not implemented ---
//			$msg = write_log("ERR","admin - not yet implemented",
//								   "admin - nicht implementiert" );
			break;
		}
		}
	}
}
?>
<!DOCTYPE html>
<html lang="<?=LANG?>">

<head>
    <title>smartSPE Administration</title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
    
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/Navigation-with-Button.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">

    <script src="assets/jquery/3.5.1/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/bootbox/js/4.4.0/bootbox.min.js"></script>
	<script src="assets/js/global.js" type='text/javascript'> </script>

	<script>
        var lang = "<?=$lang?>";
        var right = "<?=$_SESSION["rights"]?>";
        
		$(document).ready(function(){
			$('#importBtn').popover({title: "Import", content: "<?= HLP_IMPORT ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#iclearBtn').popover({title: "<?= CLEAR ?>", content: "<?= HLP_CLEAR ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
		});
        function filterProto(prot) {
            alert(prot);
            document.location.href='product.php?protocol='+prot;
        }
        function filterManu(prot) {
            alert(prot);
            document.location.href='product.php?protocol='+prot;
        }

		function call_backup() {
			var select = document.getElementById('backup_db');
			var tabl = select.options[select.selectedIndex].value;
			var srv_id = document.getElementById('server_db');
//alert(srv_id.id);
			var srv_db = srv_id.options[srv_id.selectedIndex].value;
			confText = "Backup<br>'"+srv_db+":smartSPE "+tabl+ "'<br>starten ?";
			confirmDialog(confText, function (yes) {
				if (yes) { location.href="admin.php?backup_db="+tabl+"&server_db="+srv_db; }
			});
		}
		function call_restore() {
			var select = document.getElementById('restore_db');
			var tabl = select.options[select.selectedIndex].value;
			confText = "Restore smartSPE "+tabl+" ?";
			confirmDialog(confText, function (yes) {
				if (yes) { location.href="admin.php?restore_db="+tabl; }
			});
		}
		function call_clear() {
			var select = document.getElementById('clr_type'),value;
			var type = select.options[select.selectedIndex].value;
			var list = document.getElementById('clr_list').value;
//			alert("clear smartSPE "+type+ ": "+list+" ?");
			switch (type) {
			case 'all':	confText = (lang == '_de') 	? "Wirklich alle Produkte mit Bildern löschen ?"
													: "Really delete all products with pictures ?"; break;
			case 'not':	confText = (lang == '_de') 	? "Wirklich alle Produkte mit Bildern außer von '"+list+"' löschen ?"
													: "Really delete all products with pictures except '"+list+"' ?"; break;
			case 'nur':	confText = (lang == '_de') 	? "Wirklich alle Produkte mit Bildern von '"+list+"' löschen ?"
													: "Really delete all products with pictures from '"+list+"' ?";	break;
			default:
				confText = 'undefined';
			}
			confirmDialog(confText, function (yes) {
				if (yes) { location.href="admin.php?clear&type="+type+"&list="+list; }
			});
		}
	</script>

</head>

<body class="d-flex flex-column min-vh-100">

<body>
<!-- ----------------------------- Page header ----------------------------- -->
<header>
	<table id="nav_table" class='table nowrap' style='width:100%'>
		<tr class='bg-light'>
			<td class='col-sm-2 bg-light'>
				<a class='navbar-brand logo'  target='_blank' href="<?= SPE_LINK ?>" >
					<img class='img-responsive' src='upload/Common/SPE_logo_black.png' alt='SPE Logo' width='100%'>
				</a>
			</td>
			<td class='bg-light'><h3 style='font-size: 3vw;'>Administration</h3></td>
			<td class='col-sm-6'> </td>
			<td class='col-sm-4' style='vertical-align: middle; text-align:right;'>
				<button class='btn btn-primary admin' onClick="location.href = 'product.php' ">Product</button>
				<button class='btn btn-warning home'  onClick="location.href = 'home.php'  ">Home</button>
			</td>
		</tr>
		<tr style = "background-imgage: url('assets/images/bg_header.png')">
<!--			<img src = 'assets/images/bg_header.png' class = 'img-responsive' width='100%' alt = 'blue header' ></td>	-->
		</tr>
	</table>
</header>
<?php
	require_once ("assets/php/message.php");
	require_once ("assets/html/clear.html"); 	// ----- clear product modal ---
	if ( !empty($msg) ) { 
?>	<script>
		$('#msgModal').modal("show");
	</script>
<?PHP }	?>
<!-- ------------------------------ Page content --------------------------- -->
<content>
    <main class="page catalog-page">
        <section class="clean-block clean-catalog dark">
                 <div class="content">
                    <div class="row">
<!-- left column (md-3) ---------------------------------------------------- --
                        <div class="col-md-3 text-center">
									<!-- ------------------------- Mangement --
							<div class='btn-group-vertical' style='width:100%;'>
								<h4 style='width:100%;'>Management</h4>
								<button class="btn btn-primary m-1 super" onClick="location.href='user.php' " ><?=USER?></button>
								<button class="btn btn-primary m-1" onClick="location.href='potm.php' " ><?=POTM?></button>
								<button class="btn btn-primary m-1" onClick="location.href='task.php' " ><?=TASK?></button>
								<button class="btn btn-primary m-1" onClick="location.href='supplier.php' " ><?=SUPPLIER?></button>
								<button class="btn btn-primary m-1" onClick="location.href='link_checker.php?show=all' " >Link Checker All</button>
								<button class="btn btn-warning m-1" onClick="location.href='link_checker.php?show=error' " >Link Checker Error</button>
								<button class="btn btn-primary m-1" onClick="window.open('assets/phpFileManager/index.php','', 'width=1400, height=900');" ><?=FILE?></button>
							</div>
                                    <!-- -------------------------- Database --
							<div class="btn-group-vertical" style='width:100%'>
								<h4 style='width:100%;'>Database</h4>
								<button class="btn btn-primary m-1" onClick="backup_db();" >DB Backup</button>
								<button class="btn btn-primary m-1" onClick="restore_db();" >DB Restore</button>
							</div>
                                   <!-- --------------------- Documentation --
							<div class="btn-group-vertical" style='width:100%'>
								<h4 style='width:100%;'><?=DOCU?></h4>
								<button type="button" class="btn btn-primary m-1" onClick="location.href='faq.php' " >FAQ</button>
 							</div>
                                   <!-- ---------------------- Import/Export --
							<div class="btn-group-vertical admin" style='width:100%'>
								<h4 style='width:100%;'>Im/Export</h4>
								<button class="btn btn-warning btn-w100 m-1" onClick="clear_db();"><?=CLEAR?></button>
								<form name="uploadFrm" action="admin.php?import" method="post" enctype="multipart/form-data"> 
									<div class="admin m-1 text-left" >
										<input type="text" name="foldername" class="w-100 m-1" placeholder="Backup Folder or recreate" />
										<input type="file" name="files[]" class="w-100 m-1" id="files" multiple 
											directory="" webkitdirectory="" moxdirectory="" onchange="document.uploadFrm.submit();" /> 
										<input type="hidden" value="upload" name="upload" />
									</div>
								</form>
							</div>
                        </div>
<!-- right column (md-3) --------------------------------------------------- -->
                        <div class="col-md-12">
                            <div class="products">
                                <div class="row no-gutters">
                                    <div class="col-12 col-md-6 col-lg-2 super">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="location.href='user.php' " ><?=USER?></button>
                                            <p'><?=SRT_USER?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="location.href='potm.php' " ><?=POTM?></button>
                                            <p'><?=SRT_POTM?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="location.href='task.php' " ><?=TASK?></button>
                                            <p'><?=SRT_TASK?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="location.href='supplier.php' " ><?=SUPPLIER?></button>
                                            <p'><?=SRT_SUPP?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button type="button" class="btn btn-primary w-100" onClick="location.href='faq.php' " >FAQ</button>
                                            <p'><?=SRT_FAQ?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="window.open('assets/phpFileManager/index.php','', 'width=1400, height=900');" ><?=FILE?></button>
                                            <p'><?=SRT_FILE?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="location.href='link_checker.php?show=all' " >Link Checker All</button>
											<button class="btn btn-warning w-100" onClick="location.href='link_checker.php?show=error'">Link Checker Error</button>
                                            <p'><?=SRT_SUPP?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick="" >DB Backup</button>										
											<div class="text-center"><label for="backup_db">Choose Tables:</label><br>
												<select style="width:80%" name="backup_db" id="backup_db">
													<option value="all">all Tables</option>
													<option value="product">product</option>
													<option value="task_list">task_list</option>
													<option value="supplier">supplier</option>
													<option value="potm">potm</option>
												</select><br> 
												<select style="width:80%" name="server_db" id="server_db">
<?PHP							foreach ($host_params as $srv) {
									if ($srv["srv"] == $host) $sel = "selected"; else $sel = "";
									echo "<option value='{$srv["srv"]}' {$sel} >{$srv["srv"]}</option>";
								}	?>
<!--													<option value="qoscom">qoscom</option>
													<option value="spe.info">spe</option>	-->
												</select><br> 
												<button class="btn btn-sm btn-warning w-40" onClick=call_backup() >Backup</button>
											</div>										
                                            <p><?=SRT_BACKUP?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-2">
                                        <div class="clean-product-item">
											<button class="btn btn-primary w-100" onClick=";" >DB Restore</button>
											<div class="text-center"><label for="restore_db">Choose Backup:</label><br>
												<select style="width:80%" name="restore_db" id="restore_db">
<?PHP	$db_folder = "$backup_fldr/Database";
		$db_files = scandir($db_folder);
		$file_no = 0;
		foreach ($db_files as $db_file) {
			if ($db_file == "." or $db_file == ".." or is_dir("$db_file") ) continue; ?>
													<option value="<?= $db_file ?>" ><?= $db_file ?></option>
<?PHP	} ?>
												</select><br> 
												<button class="btn btn-sm btn-warning w-40" onClick=call_restore() >Restore</button>
											</div>										
                                            <p'><?=SRT_RESTORE?></p>
                                        </div>
                                    </div>
                                    <div class='col-12 col-md-6 col-lg-2 admin'>
                                        <div class='clean-product-item'>
											<button id='clearBtn' class="btn btn-primary w-100" onClick="" ><?=CLEAR?></button>
											<div class="text-center"><label for="clr_type">Choose Suppliers:</label><br>
												<select style="width:24%" name="clr_type" id="clr_type">
													<option value="all">all</option>
													<option value="nur">only</option>
													<option value="not">not</option>
												</select> 
												<input style="width:74%" name="clr_list" id="clr_list" value="" ><br>
												<button class="btn btn-sm btn-warning w-40" onClick="call_clear()" >Clear</button>
											</div>
                                            <p><?=SRT_CLEAR?></p>
                                        </div>
                                    </div>
                                    <div class='col-12 col-md-6 col-lg-2 admin'>
                                        <div class='clean-product-item'>
											<form name='uploadFrm1' action='admin.php?import' method='post' enctype='multipart/form-data'> 
												<button id='importBtn' class='btn btn-success w-100' >Import</button>
												<input type='text' name='foldername' class='w-100 m-1' placeholder='Backup Folder or recreate' />
												<input type='file' name='files[]' id='files' class='w-100 m-1' multiple 
													directory='' webkitdirectory='' moxdirectory='' onchange='document.uploadFrm1.submit();' /> 
												<input type='hidden' value='upload' name='upload' />
                                            	<p'><?=SRT_IMPORT?></p>
                                            </form>
                                        </div>
                                    </div>
								</div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </main>
</content>

<script type="text/javascript">
	var lang  	= "<?=$_SESSION["lang"] ?>";
	var right 	= "<?=$_SESSION["rights"] ?>";
</script>
            <!-- --------------------- Page footer ------------------------- -->
<?php require_once ("assets/php/footer_small.php"); ?>

	<script src="assets/js/display.js"></script>

</body>
</html>
