<?PHP
/*
 * ****************************** index.php ************************************
 *
 * Copyright 2021 Hans <hans.lackner@qoscom.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * *****************************************************************************
 */
if (session_id() == '') { session_start(); };
require_once ("assets/php/global.php");
//echo("<pre>"); print_r($_GET); echo("</pre>");

	$msg = (isset($_GET['msg'])) ? $_GET['msg'] : '';
	$fct = (isset($_GET['fct'])) ? $_GET['fct'] : '';
	$act_email = 0;
	switch ($fct) {
	case "register": {			// ******************************** register ***
		if (!isset($_GET["hash"])) break;
		$hash = $_GET["hash"];
		if (!isset($_GET["email"])) break;
		$email = $_GET["email"];

		$sql = "SELECT * FROM accounts WHERE email=? and pend_hash=? and state = 'pend' ";
		$res = prep_select($products_db, $sql, [ $email, $hash ]);
		if ($res) {
			$row = $res->fetch_assoc();
			$sql = "UPDATE accounts SET state='ack', pend_hash='' WHERE email=? AND pend_hash=? ";
			prep_query($products_db, $sql, [ $email, $hash ]) or die(mysqli_error($products_db));
			$msg = write_log("MSG", $row["user"].REG_ACK);
		} else { $msg = write_log("ERR",NO_ACCOUNT); } 
		} break;
	case "renew": {				// ************************** renew password ***
		if (!isset($_GET['hash'])) 	
			{ $msg = write_log("ERR ".INV_INPUT.$_GET['email']); break; }
		if (!isset($_GET['email'])) 
			{ $msg = write_log("ERR ".INV_INPUT.$_GET['email']); break; }
		$hash  = $_GET["hash"];
		$email = $_GET["email"];

		$sql = "SELECT * FROM accounts WHERE email=? AND pend_hash=?  AND state='ren' ";
		$res = prep_select($products_db, $sql, [ $email, $hash ]);
		$row = $res->fetch_assoc();
  		if (!$row)	{ $msg = "ERR ".NO_ACCOUNT.$_GET['email']; break; }
  		$act_email = $email;
		} break;
 	case "vote": {				// *********** handler for users vote answer ***
		if (!isset($_GET["hash"])) {
			$msg = write_log("WRN", 'no vote response hash'); break; 
		}
		$hash = $_GET["hash"];
		if (!isset($_GET["email"])) {
			$msg = write_log("WRN", 'no voter email on resonse message'); break; 
		}
		$email = $_GET["email"];

		$sql = "SELECT * FROM `accounts` WHERE email=? ";
		$res = prep_select($products_db, $sql, [ $email ]);
		if ($row = $res->fetch_assoc() ) {
			if ($row["pend_hash"] == $hash) {
				
//console_log("$email, $hash");
				$sql = "UPDATE accounts SET v_state='cnt', pend_hash='' WHERE email=? and `pend_hash`=? ";
//console_log($sql);
				prep_query($products_db, $sql, [ $email, $hash ]) or die(mysqli_error($products_db));
//console_log("{$row["v_potm"]}, {$row["v_no"]} ");
				$sql = "UPDATE `potm` SET `counter` = `counter` + 1 WHERE `vote` = ? AND `candidate` = ? LIMIT 1 ";
//console_log($sql);
				prep_query($products_db, $sql, [ $row["v_potm"], $row["v_no"] ]) or die(mysqli_error($products_db));
				$msg = write_log("MSG", $row["user"].VOTE_ACK.": ".VOTE_DSC1.": {$row["v_potm"]}, ".VOTE_DSC.": {$row["v_no"] }.");
			} else {
				$msg = write_log("MSG", HAVE_VOTE); 
			}
		} else { 
			$msg = write_log("ERR",NO_ACCOUNT); 
		} 
		echo "<script>window.close </script>";
		exit();
		} break;
  	default: {					// ********************************* default ***
		} break;
	}
//$lang = (isset($_SESSION['lang'])) ? _$_SESSION['lang'] : 'de_DE';
$spe_link = ($_SESSION['lang'] == '_en') ? 'https://www.single-pair-ethernet.com' : 'https://www.single-pair-ethernet.de';
?>
<!DOCTYPE html>
<html lang="<?=$lang?>">

<head>
    <title>smartSPE</title>
	<meta name="description" content="<?=DESCR?>">
	<meta name="keywords" content="SPE Database, SPE, Ethernet, IEEE802.3, SPE Partner">
	<meta name="author" content="Hans Lackner">
	<meta name="viewport" content="width=device-width, initial-scale=1.0"> 
	<meta charset="utf-8">
    
    <link href="assets/css/Navigation-with-Button.css" rel="stylesheet" >
    <link rel="stylesheet" href="assets/bootstrap5/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/shards/css/shards.min.css">
    <link rel="stylesheet" href="assets/css/smartspe.css">
<!--	<link rel="stylesheet" href="assets/css/chat-2.css" >	-->
	<style>
		.truncate { max-height: 80px; width: 80; overflow: hidden;
			display:inline-block; white-space: nowrap; text-overflow: ellipsis; }
	</style>

	<script src="assets/jquery/3.5.1/jquery.min.js"></script>
<!-- script src="assets/bootstrap/js/popper.min.js"></script>	-->
	<script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/global.js"></script>
<!--	<script src="assets/js/chat-2.js"></script>	-->
	<script src="assets/js/user_mngt.js"></script>
    
	<script>
		var session_lang = "<?= $_SESSION['lang'] ?>";
		var msg_posted 	= "<?= $msg ?>";
		var NO_EMAIL 	= "<?= NO_EMAIL ?>";
		$(document).ready(function(){
//			$('[data-toggle="tooltip"]').tooltip()
			$('#loginBtn').popover({title: "<?=LOGIN?>", content: "<?= HLP_LOGIN ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#registerBtn').popover({title: "<?=REGISTER?>", content: "<?= HLP_REGISTER ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#forgotBtn').popover({title: "<?=FORGOTTEN?>", content: "<?= HLP_FORGOTTEN ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('#flagBtn').popover({title: "<?=LANGUAGE?>", content: "<?= HLP_LANGUAGE ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('.my_favorite').popover({title: "<?=SPE_CHAMP?>", content: "<?= HLP_POTM ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
			$('.catBtn').popover({title: "<?=CAT_HDR?>", content: "<?= HLP_CAT ?>", trigger: "hover", delay: {show: 500, hide: 100}}); 
		});
	</script>

</head>

<body class="d-flex flex-column min-vh-100">
<!-- ------------------------- Navigation header -++------------------------ -->
<header>
    <nav class="navbar navbar-light navbar-expand-md bg-white mt-1">
		<div class="container-fluid">
            <a class="navbar-brand logo"  target="_blank" href="<?= $spe_link ?>">
                <img class="img-responsive" src="upload/Common/SPE_logo_black.png" style="width: 300px"></a>
			<h2><?=SPE_DB?></h2>
			<nav class="navbar navbar-light navbar-expand-md navigation-clean-button">
                <div class="container">
					<button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1">
						<span class="sr-only">Toggle navigation</span>
						<span class="navbar-toggler-icon"></span>
					</button>
                    <div class="collapse navbar-collapse" id="navcol-1">
                        <ul class="nav navbar-nav mr-auto">
							<li id="flagBtn" class="nav-item">
								<a class="nav-link" href="#"><img src="assets/icons/signs/<?=FLAG?>" ></a>
							</li>
                        </ul>
                        <span class="navbar-text actions"> 
							<button id="loginBtn" class="btn btn-light action-button btn-w100" role="button" >Login</button>
<!--						<button id="chatBtn" class="btn btn-light action-button btn-w100" role="button" >Chat</button>  -->
                        </span>
					</div>
                </div>
            </nav>
		</div>
	</nav>
</header>
<!-- ------------------------------ modal section -------------------------- -->
<?PHP 
	require_once ("assets/php/message.php"); 	// ----------- message modal ---
	require_once ("assets/html/login.html"); 	// ------------- login modal ---
	require_once ("assets/html/register.html");	// ---------- register modal ---
	require_once ("assets/html/vote.html");	 	// -------------- vote modal ---
	require_once ("assets/html/chat.html");	 	// -------------- chat modal ---
	if ($act_email) 							// ------------- renew modal ---
		require_once ("assets/php/renew.php"); 
	if ( !empty($msg) ) { 
?>		<script>
			$('#msgModal').modal("show");
//			var newURL = location.href.split("?")[0];
//			window.history.pushState('object', document.title, newURL);
		</script>
<?PHP } ?>
<!-- ------------------------------ main section -------------------------- -->
<content>
    <main class="page landing-page bg-primary m-3">
<!--
        <div class="container">
            <div class="row" >
                <div class="col-sm-3 ">
                    <div class="text-center">
                        <h4 class='text-white'><?=SPE_DB?></h4>
                    </div>
                </div>
                <div class="col-sm-9">
                    <div class="text-center">
                        <h4 class='text-white'><?=SPE_CHAMP?></h4>
                    </div>
                </div>
            </div>
-->
<!-- ------------------------------ page content --------------------------- -->
            <div class="row">
<?PHP
	$sql =  ($_SESSION["lang"] == "_de")
		? "SELECT id, img, cat_de AS cat, descr_de AS descr FROM category WHERE id NOT LIKE 'c0%'"
		: "SELECT id, img, cat_en AS cat, descr_en AS descr FROM category WHERE id NOT LIKE 'c0%'";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	$cat_no = mysqli_num_rows($res);
	$act = " class='active' ";
	$hdr_cat = ($lang = '_de') ? 'in der Produkt Datenbank' : 'in the product database';

?>
			<div class="col-sm-1">
			</div>
<!-- ----------------------------- category carousel ----------------------- -->
			<div class="col-sm-2">
				<h4 class="text-center text-white mt-2"><?=CAT_HDR?></h4>
				<h6 class="text-center text-white mt-2"><?=$hdr_cat?></h6>

				<div id="catCarousel" class="carousel slide" data-ride="carousel">

													<!----------- Indicators -->
					<ul class="carousel-indicators">
						<li data-target="#catCarousel" data-slide-to="0" <?= $act ?> ></li>
<?PHP $act = "";
	  for ($i = 1; $i <= $cat_no; $i++) { ?>
			<li data-target="#catCarousel" data-slide-to="<?= $i ?>" <?= $act ?> ></li>
<?PHP } 
	  $act = " active ";?>
					</ul>
													<!-------- The slideshow -->
					<div class="carousel-inner bg-white rounded  bg-secondary" style="height: 500px">
						
						<div class="carousel-item <?= $act ?>">	<!-- Content -->
							<div class="card-header">
								<h5 class="card-title text-center text-white"><?= SPE_DB ?></h5>
							</div>
							<div class="card-body bg-warning">
<!--					<img class="card-img-top img-fluid" src="assets/images/tech/header_spe.png" alt="spe_database" >	-->
<?PHP	while ($row = $res->fetch_assoc()) { 
			$id = $row["id"];
			$cat = $row["cat"];	
			$descr = $row["descr"]; 
?>
								<h6><a href="javascript: login('<?=$id?>');" class="text-primary p-0"><?=$cat?></a></h6>
<?PHP 	} ?>
							</div>
							<div class="card-footer bg-secondary text-center">
								<button onClick="login('c0_all');" class="btn btn-sm btn-primary catBtn"><?=SPE_DB?></button>
							</div>
						</div>
<?PHP $act = "";
		$res->data_seek(0);
		while ($row = $res->fetch_assoc()) {
			$id  = $row["id"];
			$img = $row["img"];
			$cat = $row["cat"];	
			$descr = $row["descr"]; 
?>
						<div class="carousel-item <?= $act ?>" onClick="login('<?=$id?>');" >
							<div class="card-header">
								<h5 class="card-title text-center text-white"><?= $cat ?></h5>
							</div>
							<div class="card-body bg-warning" style="min-height:300px">
								<img class="card-img-top img-fluid" src="upload/Common/<?= $img ?>" alt="<?= $cat ?>" >
								<p class="card-text text-primary"><?= $descr ?></p>
							</div>
							<div class="card-footer bg-secondary text-center">
								<button onClick="login('<?=$id?>');" class="btn btn-sm btn-primary catBtn"><?=$cat?></button>
							</div>
						</div>
<?PHP $act = ""; } ?>
					</div>
					<button class="carousel-control-prev" href="#catCarousel" role="button" data-slide="prev">
						<span class="carousel-control-prev-icon" aria-hidden="true"></span>
						<span class="visually-hidden">Previous</span>
					</button>
					<button class="carousel-control-next" href="#catCarousel" role="button" data-slide="next">
						<span class="carousel-control-next-icon" aria-hidden="true"></span>
						<span class="visually-hidden">Next</span>
					</button>
				</div>
			</div>

<?PHP
	$sql = "SELECT vote, a2_cat_en AS a2_cat, a4_pn, a6_supp FROM potm WHERE vote = '$act_vote' ORDER BY candidate;";
	$res = $products_db->query($sql) or die(mysqli_error($products_db));
	for ($c = 1; $candi = $res->fetch_assoc();  $c++ ) {
		$vote = $candi["vote"];
		$sql = SEL_PROD."WHERE a2_cat_en=? AND a4_pn=? AND a6_supp=?";
		$ptr = prep_select($products_db, $sql, [ $candi["a2_cat"], $candi["a4_pn"], $candi["a6_supp"] ]);
		$prd = $ptr->fetch_assoc();
		
		$sql = "SELECT * FROM `potm` WHERE `vote` = ? AND `candidate` = ?";
		$ptm = prep_select($products_db, $sql, [ $vote, $c ])->fetch_assoc();
		$cnt = $ptm["counter"];
		$has_votes = ($lang = '_de') ? 'aktuelle Stimmenzahl: ' : 'actual no of votes';
		
        $_SESSION['state'] 	= 'vote';		// allow ajax request
        $_SESSION['rights']	= 'voter';
?>
<!-- ----------------------------- Champions Cards ------------------------- -->
                <div class="col-sm-2">
                    <h4 class="text-center text-white mt-2"><span><?=$vote ?></span><?=CANDIDATE?><span><?=$c?></span></h4>
                    <h6 class="text-center text-white mt-2"><?=$has_votes ?><?=$cnt?></h6>
                    <input type="hidden" id="vote_name" value="<?=$vote ?>" >
                    <input type="hidden" id="cand_no" value="<?=$c ?>" >

                    <div class="card" style="height: 500px">
<?PHP   if ($prd) { ?>
                        <div class="card-body text-center">
                            <h6 class="card-title><span id="cat"><?=$prd["a2_cat"]?></h6>
							<br><span id="pn"><?=$prd["a4_pn"]?></span></h6>
							<img class="img-fluid" style="max-height:150px; max-width:250px;"
								src='<?= "upload/{$prd["a6_supp"]}/{$prd["a1_img"]}" ?>'  alt="<?=CANDIDATE?> <?=$c ?>" />
                            <p class="card-text"><?=PRODUCT?>:
                                <span id="prod"><?=$prd["a5_pr"]?></span>	
                                <br><?=SUPPLIER?>: <span id="supp"><?=$prd["a6_supp"]?></span>
                                <br><a id="ref" href="<?= $prd["a7_ref"] ?>"><?=MORE_PROD?></a>
                            </p>
                        </div>
                        <div class="card-footer bg-light text-center">
                            <button onClick="show_vote('<?=$vote?>',<?=$c?>,'<?=$prd["a4_pn"]?>','<?=$prd["a2_cat"]?>','<?=$prd["a5_pr"]?>','<?=$prd["a6_supp"] ?>');"  
                                class="btn btn-sm btn-primary my_favorite"><?=MY_FAVOR?></a>
                        </div>
<?PHP       } else { ?>
                        <div class="card-body">
                            <h6 class="card-title"><span id="cat"><?=CANDIDATE?> ?</span>
                            <br><span id="pn"><?=PRODUCT?> ?</span></h6>
                        </div>
                        <div class="card-footer bg-light text-center">
                            <button class="btn btn-sm btn-primary my_favorite"><?=NO_FAVOR?></a>
                        </div>
<?PHP       } ?>
                    </div>
                </div>
<?PHP  } ?>
<!-- -------------------------- meet.jit.si/smartSPE ----------------------- -->
                <div class="col-sm-2">
					<h4 class="text-center text-white mt-2">meet SPE</h4>
					<h6 class="text-center text-white mt-2">meet.jit.si/smartSPE</h6>

                    <iframe allow="camera; microphone; fullscreen; display-capture; autoplay" 
                        src="https://meet.jit.si/smartSPE" 
                        style="height: 90%; width: 100%; border: 0px;">
                    </iframe>
                </div>
				<div class="col-sm-1">	</div>
            </div>
<!-- ------------------------------- title --------------------------------- -->
            <div class="row" >
				<div class="col-sm-1">	</div>
                <div class="col-sm-2 bg-primary">
                    <div class="text-center">
                        <h4 class='text-white'><?=SPE_DB?></h4>
                    </div>
                </div>
                <div class="col-sm-6 bg-primary">
                    <div class="text-center">
                        <h4 class='text-white'><?=SPE_CHAMP?></h4>
                    </div>s
                </div>
                <div class="col-sm-2 bg-primary">
                    <div class="text-center">
                        <h4 class='text-white'>meet me</h4>
                    </div>
                </div>
 				<div class="col-sm-1">	</div>
           </div>
 	</main>
</content>
    
<?php require_once ("assets/php/footer.php"); ?>
<script>
	sessionStorage.setItem('index', 0); 
	window.addEventListener('storage',() => {
		alert( sessionStorage.getItem('index') );
		window.location.reload(true);
	});
</script>
		
</body>
</html>

